/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.mime;

import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import javax.annotation.Nonnull;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.codec.QuotedPrintableCodec;
import saoui.shade.com.helger.commons.codec.URLCodec;
import saoui.shade.com.helger.commons.mime.MimeTypeParser;

public enum EMimeQuoting {
    QUOTED_STRING{

        @Override
        @Nonnull
        @Nonempty
        public String getQuotedString(@Nonnull @Nonempty String string) {
            char[] cArray;
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            stringBuilder.append('\"');
            for (char c : cArray = string.toCharArray()) {
                if (c == '\"' || c == '\\') {
                    stringBuilder.append('\\').append(c);
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.append('\"').toString();
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnquotedString(@Nonnull @Nonempty String string) {
            throw new UnsupportedOperationException("This is handled directly inside the MimeTypeParser!");
        }
    }
    ,
    QUOTED_PRINTABLE{

        @Override
        @Nonnull
        @Nonempty
        public String getQuotedString(@Nonnull @Nonempty String string) {
            return new QuotedPrintableCodec(PRINTABLE_QUOTED_PRINTABLE).getEncodedAsString(string, StandardCharsets.UTF_8);
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnquotedString(@Nonnull @Nonempty String string) {
            return new QuotedPrintableCodec().getDecodedAsString(string, StandardCharsets.UTF_8);
        }
    }
    ,
    URL_ESCAPE{

        @Override
        @Nonnull
        @Nonempty
        public String getQuotedString(@Nonnull @Nonempty String string) {
            return new URLCodec(PRINTABLE_URL).getEncodedAsString(string, StandardCharsets.UTF_8);
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnquotedString(@Nonnull @Nonempty String string) {
            return new URLCodec(PRINTABLE_URL).getDecodedAsString(string, StandardCharsets.UTF_8);
        }
    };

    public static final char QUOTED_STRING_SEPARATOR_CHAR = '\"';
    public static final char QUOTED_STRING_MASK_CHAR = '\\';
    private static final BitSet PRINTABLE_QUOTED_PRINTABLE;
    private static final BitSet PRINTABLE_URL;

    @Nonnull
    @Nonempty
    public abstract String getQuotedString(@Nonnull @Nonempty String var1);

    @Nonnull
    @Nonempty
    public abstract String getUnquotedString(@Nonnull @Nonempty String var1);

    public boolean isQuotedString() {
        return this == QUOTED_STRING;
    }

    static {
        PRINTABLE_QUOTED_PRINTABLE = QuotedPrintableCodec.getDefaultPrintableChars();
        PRINTABLE_URL = URLCodec.getDefaultPrintableChars();
        PRINTABLE_QUOTED_PRINTABLE.set(9, false);
        PRINTABLE_QUOTED_PRINTABLE.set(32, false);
        PRINTABLE_URL.set(32, false);
        for (char c : MimeTypeParser.getAllTSpecialChars()) {
            PRINTABLE_QUOTED_PRINTABLE.set((int)c, false);
            PRINTABLE_URL.set((int)c, false);
        }
    }
}

