/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.mime;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.ArrayHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.io.ByteArrayWrapper;
import saoui.shade.com.helger.commons.mime.IMimeType;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@Immutable
@MustImplementEqualsAndHashcode
public class MimeTypeContent {
    public static final boolean DEFAULT_COPY_BYTES = true;
    private final ByteArrayWrapper m_aContentBytes;
    private final IMimeType m_aMimeType;

    public MimeTypeContent(@Nonnull @Nonempty byte[] byArray, @Nonnull IMimeType iMimeType) {
        this(byArray, true, iMimeType);
    }

    public MimeTypeContent(@Nonnull @Nonempty byte[] byArray, boolean bl, @Nonnull IMimeType iMimeType) {
        ValueEnforcer.notEmpty(byArray, "ContentBytes");
        ValueEnforcer.notNull(iMimeType, "MimeType");
        this.m_aContentBytes = new ByteArrayWrapper(byArray, bl);
        this.m_aMimeType = iMimeType;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getAllContentBytes() {
        return this.m_aContentBytes.getAllBytes();
    }

    @Nonnegative
    public int getContentByteCount() {
        return this.m_aContentBytes.size();
    }

    public void writeContentBytes(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        this.m_aContentBytes.writeTo(outputStream);
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    public boolean matchesBeginning(@Nonnull byte[] byArray) {
        return ArrayHelper.startsWith(byArray, this.m_aContentBytes.bytes());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeContent mimeTypeContent = (MimeTypeContent)object;
        return this.m_aContentBytes.equals(mimeTypeContent.m_aContentBytes) && this.m_aMimeType.equals(mimeTypeContent.m_aMimeType);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aContentBytes).append(this.m_aMimeType).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ContentBytes", this.m_aContentBytes).append("MimeType", this.m_aMimeType).getToString();
    }
}

