/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.mock;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.equals.EqualsHelper;

@Immutable
public final class CommonsAssert {
    public static final float FLOAT_ALLOWED_ROUNDING_DIFFERENCE = 1.0E-4f;
    public static final double DOUBLE_ALLOWED_ROUNDING_DIFFERENCE = 1.0E-5;
    private static final CommonsAssert INSTANCE = new CommonsAssert();

    private CommonsAssert() {
    }

    public static void fail() {
        CommonsAssert.fail("Forced fail");
    }

    public static void fail(@Nonnull String string) {
        throw new IllegalArgumentException(string);
    }

    public static void assertEquals(boolean bl, boolean bl2) {
        CommonsAssert.assertEquals((String)null, bl, bl2);
    }

    public static void assertEquals(boolean bl, @Nonnull Boolean bl2) {
        ValueEnforcer.notNull(bl2, "y");
        CommonsAssert.assertEquals((String)null, bl, bl2);
    }

    public static void assertEquals(@Nullable String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            CommonsAssert.fail("<" + bl + "> is not equal to <" + bl2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }

    public static void assertEquals(double d, double d2) {
        CommonsAssert.assertEquals((String)null, d, d2);
    }

    public static void assertEquals(double d, @Nonnull Double d2) {
        ValueEnforcer.notNull(d2, "y");
        CommonsAssert.assertEquals((String)null, d, d2);
    }

    public static void assertEquals(@Nullable String string, double d, double d2) {
        if (Double.compare(d, d2) != 0 && Math.abs(d - d2) > 1.0E-5) {
            CommonsAssert.fail("<" + d + "> is not equal to <" + d2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }

    public static void assertEquals(float f, float f2) {
        CommonsAssert.assertEquals((String)null, f, f2);
    }

    public static void assertEquals(float f, @Nonnull Float f2) {
        ValueEnforcer.notNull(f2, "y");
        CommonsAssert.assertEquals((String)null, f, f2.floatValue());
    }

    public static void assertEquals(@Nullable String string, float f, float f2) {
        if (Float.compare(f, f2) != 0 && Math.abs(f - f2) > 1.0E-4f) {
            CommonsAssert.fail("<" + f + "> is not equal to <" + f2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }

    public static void assertEquals(@Nullable float[] fArray, @Nullable float[] fArray2) {
        if (fArray == fArray2) {
            return;
        }
        if (fArray == null) {
            CommonsAssert.fail("First parameter is null");
        }
        if (fArray2 == null) {
            CommonsAssert.fail("Second parameter is null");
        }
        if (fArray.length != fArray2.length) {
            CommonsAssert.fail("Length mismatch");
        }
        for (int i = 0; i < fArray.length; ++i) {
            CommonsAssert.assertEquals("Element [" + i + "] mismatch", fArray[i], fArray2[i]);
        }
    }

    public static void assertEquals(@Nullable double[] dArray, @Nullable double[] dArray2) {
        if (dArray == dArray2) {
            return;
        }
        if (dArray == null) {
            CommonsAssert.fail("First parameter is null");
        }
        if (dArray2 == null) {
            CommonsAssert.fail("Second parameter is null");
        }
        if (dArray.length != dArray2.length) {
            CommonsAssert.fail("Length mismatch");
        }
        for (int i = 0; i < dArray.length; ++i) {
            CommonsAssert.assertEquals("Element [" + i + "] mismatch", dArray[i], dArray2[i]);
        }
    }

    public static <T> void assertEquals(@Nullable T t, @Nullable T t2) {
        CommonsAssert.assertEquals((String)null, t, t2);
    }

    public static <T> void assertEquals(@Nullable String string, @Nullable T t, @Nullable T t2) {
        if (!EqualsHelper.equals(t, t2)) {
            CommonsAssert.fail("<" + t + "> is not equal to <" + t2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }

    public static <T> void assertNotEquals(@Nullable T t, @Nullable T t2) {
        CommonsAssert.assertNotEquals((String)null, t, t2);
    }

    public static <T> void assertNotEquals(@Nullable String string, @Nullable T t, @Nullable T t2) {
        if (EqualsHelper.equals(t, t2)) {
            CommonsAssert.fail("<" + t + "> is equal to <" + t2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }

    public static void assertNotEquals(boolean bl, boolean bl2) {
        CommonsAssert.assertNotEquals((String)null, bl, bl2);
    }

    public static void assertNotEquals(boolean bl, @Nonnull Boolean bl2) {
        ValueEnforcer.notNull(bl2, "y");
        CommonsAssert.assertNotEquals((String)null, bl, bl2);
    }

    public static void assertNotEquals(@Nullable String string, boolean bl, boolean bl2) {
        if (bl == bl2) {
            CommonsAssert.fail("<" + bl + "> is equal to <" + bl2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }
}

