/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.mock;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsTreeMap;
import saoui.shade.com.helger.commons.collection.impl.CommonsTreeSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsSortedMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsSortedSet;
import saoui.shade.com.helger.commons.io.file.FileHelper;
import saoui.shade.com.helger.commons.io.file.FileSystemIterator;
import saoui.shade.com.helger.commons.io.stream.NonBlockingBufferedReader;
import saoui.shade.com.helger.commons.io.stream.StreamHelper;
import saoui.shade.com.helger.commons.lang.ClassHelper;
import saoui.shade.com.helger.commons.lang.ReflectionSecurityManager;
import saoui.shade.com.helger.commons.lang.ServiceLoaderHelper;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

public final class SPITestHelper {
    public static final String TEST_SERVICES = "src/test/resources/META-INF/services";
    public static final String MAIN_SERVICES = "src/main/resources/META-INF/services";
    private static final Logger LOGGER = LoggerFactory.getLogger(SPITestHelper.class);

    private SPITestHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid(@Nonnull String string2, @Nonnull EMode eMode) throws IOException {
        ValueEnforcer.notNull(string2, "BaseDir");
        ValueEnforcer.notNull(eMode, "Mode");
        boolean bl = eMode.isResolve();
        ClassLoader classLoader = ReflectionSecurityManager.INSTANCE.getCallerClass(1).getClassLoader();
        CommonsTreeMap<String, ICommonsSortedSet<String>> commonsTreeMap = new CommonsTreeMap<String, ICommonsSortedSet<String>>();
        File file = new File(string2);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string2)) {
                Object object;
                Object object2;
                String string3;
                block25: {
                    if (!file2.isFile()) continue;
                    if (bl && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Checking SPI file " + file2.getAbsolutePath());
                    }
                    string3 = file2.getName();
                    if (bl) {
                        try {
                            object2 = classLoader.loadClass(string3);
                            if (string3.startsWith("saoui.shade.com.helger.") && !ServiceLoaderHelper.CACHE_INTERFACE.hasAnnotation((Class<?>)object2) && LOGGER.isWarnEnabled()) {
                                LOGGER.warn(object2 + " should have the @IsSPIInterface annotation");
                            }
                        }
                        catch (Exception exception) {
                            object = "No interface representing " + string3 + " exists: " + ClassHelper.getClassLocalName(exception) + " - " + exception.getMessage();
                            if (LOGGER.isWarnEnabled()) {
                                LOGGER.warn((String)object);
                            }
                            if (!eMode.isStrict()) break block25;
                            throw new IllegalStateException((String)object);
                        }
                    }
                }
                object2 = new NonBlockingBufferedReader(StreamHelper.createReader(FileHelper.getInputStream(file2), StandardCharsets.UTF_8));
                object = null;
                try {
                    String string4;
                    int n = 0;
                    while ((string4 = ((NonBlockingBufferedReader)object2).readLine()) != null) {
                        String string5 = StringHelper.trim(string4);
                        if (!StringHelper.hasText(string5)) continue;
                        if (bl) {
                            try {
                                Class<?> clazz = classLoader.loadClass(string5);
                                if (!ServiceLoaderHelper.CACHE_IMPLEMENTATION.hasAnnotation(clazz) && LOGGER.isWarnEnabled()) {
                                    LOGGER.warn(clazz + " should have the @IsSPIImplementation annotation");
                                }
                                ++n;
                                commonsTreeMap.computeIfAbsent(string3, string -> new CommonsTreeSet()).add(string5);
                                continue;
                            }
                            catch (Exception exception) {
                                if (LOGGER.isWarnEnabled()) {
                                    LOGGER.warn("  Error checking content: " + exception.getMessage());
                                }
                                if (!eMode.isStrict()) continue;
                                throw new IllegalStateException("Error checking SPI file " + file2.getAbsolutePath(), exception);
                            }
                        }
                        ++n;
                        commonsTreeMap.computeIfAbsent(string3, string -> new CommonsTreeSet()).add(string5);
                    }
                    if (!bl) continue;
                    if (n == 0) {
                        LOGGER.warn("  Contains no single valid implementation!");
                        continue;
                    }
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("  All implementations (" + n + ") are valid!");
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 == null) continue;
                    if (object != null) {
                        try {
                            ((NonBlockingBufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    ((NonBlockingBufferedReader)object2).close();
                }
            }
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllMainSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(MAIN_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllTestSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(TEST_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid(boolean bl) throws IOException {
        ICommonsSortedMap<String, ICommonsSortedSet<String>> iCommonsSortedMap = SPITestHelper.testIfAllMainSPIImplementationsAreValid(bl);
        iCommonsSortedMap.putAll(SPITestHelper.testIfAllTestSPIImplementationsAreValid(bl));
        return iCommonsSortedMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid() throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(false);
    }

    public static enum EMode {
        STRICT,
        IGNORE_ERRORS,
        NO_RESOLVE;


        public boolean isStrict() {
            return this == STRICT;
        }

        public boolean isResolve() {
            return this != NO_RESOLVE;
        }
    }
}

