/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.mutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.CGlobal;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.math.MathHelper;
import saoui.shade.com.helger.commons.mutable.AbstractMutableNumeric;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@NotThreadSafe
public class MutableBigInteger
extends AbstractMutableNumeric<MutableBigInteger> {
    private BigInteger m_aValue;

    public MutableBigInteger(long l) {
        this(BigInteger.valueOf(l));
    }

    public MutableBigInteger(@Nonnull MutableBigInteger mutableBigInteger) {
        this(mutableBigInteger.m_aValue);
    }

    public MutableBigInteger(@Nonnull BigInteger bigInteger) {
        this.m_aValue = ValueEnforcer.notNull(bigInteger, "Value");
    }

    @Override
    @Nonnull
    public BigDecimal getAsBigDecimal() {
        return new BigDecimal(this.m_aValue);
    }

    @Override
    @Nonnull
    public BigInteger getAsBigInteger() {
        return this.m_aValue;
    }

    @Override
    public double doubleValue() {
        return this.m_aValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.m_aValue.floatValue();
    }

    @Override
    public int intValue() {
        return this.m_aValue.intValue();
    }

    @Override
    public long longValue() {
        return this.m_aValue.longValue();
    }

    @Nonnull
    public BigInteger inc() {
        return this.inc(BigInteger.ONE);
    }

    @Nonnull
    public BigInteger inc(long l) {
        return this.inc(BigInteger.valueOf(l));
    }

    @Nonnull
    public BigInteger inc(@Nonnull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Delta");
        return this.inc(mutableBigInteger.m_aValue);
    }

    @Nonnull
    public BigInteger inc(@Nonnull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Delta");
        this.m_aValue = this.m_aValue.add(bigInteger);
        this.onAfterChange();
        return this.m_aValue;
    }

    @Nonnull
    public BigInteger dec() {
        return this.inc(CGlobal.BIGINT_MINUS_ONE);
    }

    @Nonnull
    public BigInteger dec(long l) {
        return this.inc(BigInteger.valueOf(-l));
    }

    @Nonnull
    public BigInteger dec(@Nonnull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Delta");
        return this.inc(mutableBigInteger.m_aValue.negate());
    }

    @Nonnull
    public BigInteger dec(@Nonnull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Delta");
        return this.inc(bigInteger.negate());
    }

    @Nonnull
    public BigInteger divide(long l) {
        return this.divide(MathHelper.toBigInteger(l));
    }

    @Nonnull
    public BigInteger divide(@Nonnull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Divisor");
        return this.divide(mutableBigInteger.m_aValue);
    }

    @Nonnull
    public BigInteger divide(@Nonnull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Divisor");
        this.m_aValue = this.m_aValue.divide(bigInteger);
        this.onAfterChange();
        return this.m_aValue;
    }

    @Nonnull
    public BigInteger multiply(long l) {
        return this.multiply(MathHelper.toBigInteger(l));
    }

    @Nonnull
    public BigInteger multiply(@Nonnull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Multiplicand");
        return this.multiply(mutableBigInteger.m_aValue);
    }

    @Nonnull
    public BigInteger multiply(@Nonnull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Multiplicand");
        this.m_aValue = this.m_aValue.multiply(bigInteger);
        this.onAfterChange();
        return this.m_aValue;
    }

    @Nonnull
    public EChange set(long l) {
        return this.set(BigInteger.valueOf(l));
    }

    @Nonnull
    public EChange set(@Nonnull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Value");
        return this.set(mutableBigInteger.m_aValue);
    }

    @Nonnull
    public EChange set(@Nonnull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Value");
        if (bigInteger.equals(this.m_aValue)) {
            return EChange.UNCHANGED;
        }
        this.m_aValue = bigInteger;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return MathHelper.isEQ0(this.m_aValue);
    }

    @Override
    public boolean isLT0() {
        return MathHelper.isLT0(this.m_aValue);
    }

    @Override
    public boolean isLE0() {
        return MathHelper.isLE0(this.m_aValue);
    }

    @Override
    public boolean isGT0() {
        return MathHelper.isGT0(this.m_aValue);
    }

    @Override
    public boolean isGE0() {
        return MathHelper.isGE0(this.m_aValue);
    }

    @Nonnull
    public BigInteger getAndInc() {
        BigInteger bigInteger = this.getAsBigInteger();
        this.inc();
        return bigInteger;
    }

    @Nonnull
    public BigInteger incAndGet() {
        this.inc();
        return this.getAsBigInteger();
    }

    @Override
    public int compareTo(@Nonnull MutableBigInteger mutableBigInteger) {
        return this.m_aValue.compareTo(mutableBigInteger.m_aValue);
    }

    @Override
    @Nonnull
    public MutableBigInteger getClone() {
        return new MutableBigInteger(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableBigInteger mutableBigInteger = (MutableBigInteger)object;
        return EqualsHelper.equals(this.m_aValue, mutableBigInteger.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).getToString();
    }
}

