/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.regex;

import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.RegEx;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.cache.Cache;
import saoui.shade.com.helger.commons.regex.RegExPattern;

@ThreadSafe
public final class RegExCache
extends Cache<RegExPattern, Pattern> {
    public static final int MAX_CACHE_SIZE = 1000;
    private static boolean s_bDefaultInstantiated = false;

    private RegExCache() {
        super(RegExPattern::getAsPattern, 1000, RegExCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static RegExCache getInstance() {
        RegExCache regExCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return regExCache;
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string) {
        return (Pattern)RegExCache.getInstance().getFromCache(new RegExPattern(string));
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string, @Nonnegative int n) {
        return (Pattern)RegExCache.getInstance().getFromCache(new RegExPattern(string, n));
    }

    private static final class SingletonHolder {
        private static final RegExCache INSTANCE = new RegExCache();

        private SingletonHolder() {
        }
    }
}

