/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.statistics;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.statistics.IMutableStatisticsHandlerCache;

@ThreadSafe
public class StatisticsHandlerCache
implements IMutableStatisticsHandlerCache {
    private final AtomicInteger m_aHits = new AtomicInteger();
    private final AtomicInteger m_aMisses = new AtomicInteger();

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void cacheHit() {
        this.m_aHits.incrementAndGet();
    }

    @Override
    public void cacheMiss() {
        this.m_aMisses.incrementAndGet();
    }

    @Override
    @Nonnegative
    public int getHits() {
        return this.m_aHits.intValue();
    }

    @Override
    @Nonnegative
    public int getMisses() {
        return this.m_aMisses.intValue();
    }
}

