/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.statistics.util;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandler;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandlerCache;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandlerCounter;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandlerKeyedCounter;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandlerKeyedSize;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandlerKeyedTimer;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandlerSize;
import saoui.shade.com.helger.commons.statistics.IStatisticsHandlerTimer;
import saoui.shade.com.helger.commons.statistics.StatisticsManager;
import saoui.shade.com.helger.commons.statistics.util.IStatisticsVisitorCallback;

@Immutable
public final class StatisticsVisitor {
    private static final StatisticsVisitor INSTANCE = new StatisticsVisitor();

    private StatisticsVisitor() {
    }

    public static void visitStatistics(@Nonnull IStatisticsVisitorCallback iStatisticsVisitorCallback) {
        IStatisticsHandler iStatisticsHandler;
        ValueEnforcer.notNull(iStatisticsVisitorCallback, "Callback");
        ICommonsList iCommonsList = StatisticsManager.getAllCacheHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getCacheHandler(string);
            iStatisticsVisitorCallback.onCache(string, (IStatisticsHandlerCache)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllTimerHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getTimerHandler(string);
            iStatisticsVisitorCallback.onTimer(string, (IStatisticsHandlerTimer)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedTimerHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedTimerHandler(string);
            iStatisticsVisitorCallback.onKeyedTimer(string, (IStatisticsHandlerKeyedTimer)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllSizeHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getSizeHandler(string);
            iStatisticsVisitorCallback.onSize(string, (IStatisticsHandlerSize)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedSizeHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedSizeHandler(string);
            iStatisticsVisitorCallback.onKeyedSize(string, (IStatisticsHandlerKeyedSize)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllCounterHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getCounterHandler(string);
            iStatisticsVisitorCallback.onCounter(string, (IStatisticsHandlerCounter)iStatisticsHandler);
        }
        iCommonsList = StatisticsManager.getAllKeyedCounterHandler().getSorted(Comparator.naturalOrder());
        for (String string : iCommonsList) {
            iStatisticsHandler = StatisticsManager.getKeyedCounterHandler(string);
            iStatisticsVisitorCallback.onKeyedCounter(string, (IStatisticsHandlerKeyedCounter)iStatisticsHandler);
        }
    }
}

