/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.system;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.ExemptionMechanism;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public final class CryptoPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoPolicy.class);
    private static final AtomicBoolean CHECKED = new AtomicBoolean(false);
    private static boolean s_bUnlimitedStrength;
    private static final CryptoPolicy INSTANCE;

    private CryptoPolicy() {
    }

    private static boolean _isUnlimitedStrengthAvailable() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] byArray = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, secretKeySpec);
            byte[] byArray2 = cipher.doFinal("1234567890123456".getBytes(StandardCharsets.ISO_8859_1));
            if (byArray2 == null) {
                throw new IllegalStateException("Encryption of test string failed!");
            }
            ExemptionMechanism exemptionMechanism = cipher.getExemptionMechanism();
            if (exemptionMechanism != null) {
                LOGGER.info("Cipher uses exemption mechanism " + exemptionMechanism.getName());
                return false;
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.info("Invalid key size - unlimited strength crypto NOT installed!");
            return false;
        }
        catch (Exception exception) {
            LOGGER.info("Failed to determine unlimited strength crypto state", exception);
            return false;
        }
        return true;
    }

    public static boolean isUnlimitedStrengthCryptoAvailable() {
        if (!CHECKED.getAndSet(true)) {
            s_bUnlimitedStrength = CryptoPolicy._isUnlimitedStrengthAvailable();
        }
        return s_bUnlimitedStrength;
    }

    static {
        INSTANCE = new CryptoPolicy();
    }
}

