/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.system;

import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.system.EJVMVendor;
import saoui.shade.com.helger.commons.system.EJavaVersion;
import saoui.shade.com.helger.commons.system.EOperatingSystem;
import saoui.shade.com.helger.commons.system.EProcessorArchitecture;

@Immutable
public final class SystemHelper {
    private static final int NUMBER_OF_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final SystemHelper INSTANCE = new SystemHelper();

    private SystemHelper() {
    }

    @Nonnegative
    public static int getNumberOfProcessors() {
        return NUMBER_OF_PROCESSORS;
    }

    @Nonnull
    public static EProcessorArchitecture getProcessorArchitecture() {
        return EProcessorArchitecture.getCurrentArchitecture();
    }

    @Nonnull
    public static EOperatingSystem getOperatingSystem() {
        return EOperatingSystem.getCurrentOS();
    }

    @Nonnull
    public static String getOperatingSystemName() {
        return EOperatingSystem.getCurrentOSName() + " [" + EOperatingSystem.getCurrentOSVersion() + "]";
    }

    @Nonnull
    public static EJavaVersion getJavaVersion() {
        return EJavaVersion.getCurrentVersion();
    }

    @Nonnull
    public static EJVMVendor getJVMVendor() {
        return EJVMVendor.getCurrentVendor();
    }

    @Nonnull
    public static Locale getSystemLocale() {
        return Locale.getDefault();
    }

    @Nonnull
    public static Charset getSystemCharset() {
        return Charset.defaultCharset();
    }

    @Nonnull
    public static String getSystemCharsetName() {
        return SystemHelper.getSystemCharset().name();
    }

    @Nonnegative
    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Nonnegative
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Nonnegative
    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }
}

