/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.text;

import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableObject;
import saoui.shade.com.helger.commons.callback.CallbackList;
import saoui.shade.com.helger.commons.callback.IChangeCallback;
import saoui.shade.com.helger.commons.collection.impl.ICommonsOrderedMap;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.lang.IHasSize;
import saoui.shade.com.helger.commons.locale.LocaleHelper;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.state.EContinue;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.commons.text.AbstractReadOnlyMapBasedMultilingualText;
import saoui.shade.com.helger.commons.text.IMultilingualText;
import saoui.shade.com.helger.commons.text.IMutableMultilingualText;

@NotThreadSafe
public abstract class AbstractMapBasedMultilingualText
extends AbstractReadOnlyMapBasedMultilingualText
implements IMutableMultilingualText {
    private final transient CallbackList<IChangeCallback<IMutableMultilingualText>> m_aChangeNotifyCallbacks = new CallbackList();

    public AbstractMapBasedMultilingualText() {
    }

    protected AbstractMapBasedMultilingualText(@Nonnull ICommonsOrderedMap<Locale, String> iCommonsOrderedMap) {
        super(iCommonsOrderedMap);
    }

    @Nonnull
    private EContinue _beforeChange() {
        return this.m_aChangeNotifyCallbacks.forEachBreakable((Function<IChangeCallback<IMutableMultilingualText>, EContinue>)((Function<IChangeCallback, EContinue>)iChangeCallback -> iChangeCallback.beforeChange(this)));
    }

    private void _afterChange() {
        this.m_aChangeNotifyCallbacks.forEach((Consumer<IChangeCallback<IMutableMultilingualText>>)((Consumer<IChangeCallback>)iChangeCallback -> iChangeCallback.afterChange(this)));
    }

    @Override
    @Nonnull
    public final EChange addText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (this.texts().containsKey(locale)) {
            return EChange.UNCHANGED;
        }
        if (this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(locale, string);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange setText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (this.texts().containsKey(locale)) {
            String string2 = this.internalGetText(locale);
            if (EqualsHelper.equals(string2, string)) {
                return EChange.UNCHANGED;
            }
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.internalSetText(locale, string);
        } else {
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.internalAddText(locale, string);
        }
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeText(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            if (!this.texts().containsKey(locale2)) continue;
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.texts().remove(locale2);
            this._afterChange();
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeAll() {
        if (this.texts().isEmpty() || this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.texts().clear();
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange assignFrom(@Nonnull IMultilingualText iMultilingualText) {
        ValueEnforcer.notNull(iMultilingualText, "MLT");
        if (this.texts().equals(iMultilingualText.texts()) || this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.texts().clear();
        for (Map.Entry<Locale, String> entry : iMultilingualText.texts().entrySet()) {
            this.internalAddText(entry);
        }
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(value="design")
    public final CallbackList<IChangeCallback<IMutableMultilingualText>> changeNotifyCallbacks() {
        return this.m_aChangeNotifyCallbacks;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIf("ChangeNotifyCallbacks", this.m_aChangeNotifyCallbacks, IHasSize::isNotEmpty).getToString();
    }
}

