/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.text.codepoint;

import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.text.codepoint.Codepoint;
import saoui.shade.com.helger.commons.text.codepoint.CodepointIteratorRestricted;
import saoui.shade.com.helger.commons.text.codepoint.ICodepointIterator;
import saoui.shade.com.helger.commons.text.codepoint.InvalidCharacterException;

public abstract class AbstractCodepointIterator
implements ICodepointIterator {
    protected int m_nPosition = -1;
    protected int m_nLimit = -1;

    protected AbstractCodepointIterator() {
    }

    protected AbstractCodepointIterator(int n, int n2) {
        this.m_nPosition = n;
        this.m_nLimit = n2;
    }

    protected abstract char get();

    protected abstract char get(int var1);

    @Override
    @CheckForSigned
    public int lastPosition() {
        int n = this.position();
        if (n < 0) {
            return -1;
        }
        return n >= this.limit() ? n : n - 1;
    }

    @Override
    @Nullable
    public char[] nextChars() {
        if (this.hasNext()) {
            if (this._isNextSurrogate()) {
                char c = this.get();
                if (Character.isHighSurrogate(c) && this.position() < this.limit()) {
                    char c2 = this.get();
                    if (Character.isLowSurrogate(c2)) {
                        return new char[]{c, c2};
                    }
                    throw new InvalidCharacterException(c2);
                }
                if (Character.isLowSurrogate(c) && this.position() > 0) {
                    char c3 = this.get(this.position() - 2);
                    if (Character.isHighSurrogate(c3)) {
                        return new char[]{c, c3};
                    }
                    throw new InvalidCharacterException(c3);
                }
            }
            return new char[]{this.get()};
        }
        return null;
    }

    @Override
    @Nullable
    public char[] peekChars() {
        return this._peekChars(this.position());
    }

    @Nullable
    private char[] _peekChars(@Nonnegative int n) {
        if (n < 0 || n >= this.limit()) {
            return null;
        }
        char c = this.get(n);
        if (Character.isHighSurrogate(c) && n < this.limit()) {
            char c2 = this.get(n + 1);
            if (Character.isLowSurrogate(c2)) {
                return new char[]{c, c2};
            }
            throw new InvalidCharacterException(c2);
        }
        if (Character.isLowSurrogate(c) && n > 1) {
            char c3 = this.get(n - 1);
            if (Character.isHighSurrogate(c3)) {
                return new char[]{c3, c};
            }
            throw new InvalidCharacterException(c3);
        }
        return new char[]{c};
    }

    @Override
    @Nonnull
    public Codepoint next() {
        Codepoint codepoint = AbstractCodepointIterator._toCodepoint(this.nextChars());
        if (codepoint == null) {
            throw new NoSuchElementException();
        }
        return codepoint;
    }

    @Override
    @Nullable
    public Codepoint peek() {
        return AbstractCodepointIterator._toCodepoint(this.peekChars());
    }

    @Override
    @Nullable
    public Codepoint peek(int n) {
        return AbstractCodepointIterator._toCodepoint(this._peekChars(n));
    }

    @Nullable
    private static Codepoint _toCodepoint(@Nullable char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        return new Codepoint(cArray);
    }

    private void _checkLimit(@Nonnegative int n) {
        if (n < 0 || n > this.limit()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    @Override
    public void position(@Nonnegative int n) {
        this._checkLimit(n);
        this.m_nPosition = n;
    }

    @Override
    @Nonnegative
    public int position() {
        return this.m_nPosition;
    }

    @Override
    @Nonnegative
    public int limit() {
        return this.m_nLimit;
    }

    @Override
    @Nonnegative
    public int remaining() {
        return this.m_nLimit - this.position();
    }

    private boolean _isNextSurrogate() {
        if (!this.hasNext()) {
            return false;
        }
        char c = this.get(this.position());
        return Character.isHighSurrogate(c) || Character.isLowSurrogate(c);
    }

    @Override
    public boolean isHigh(@Nonnegative int n) {
        this._checkLimit(n);
        return Character.isHighSurrogate(this.get(n));
    }

    @Override
    public boolean isLow(@Nonnegative int n) {
        this._checkLimit(n);
        return Character.isLowSurrogate(this.get(n));
    }

    @Override
    @Nonnull
    public CodepointIteratorRestricted restrict(@Nonnull IntPredicate intPredicate, boolean bl, boolean bl2) {
        return new CodepointIteratorRestricted(this, intPredicate, bl, bl2);
    }
}

