/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.text.codepoint;

import java.util.function.IntPredicate;
import javax.annotation.Nonnull;
import saoui.shade.com.helger.commons.text.codepoint.CodepointHelper;

public enum ECodepointProfile {
    NONE(n -> true),
    ALPHA(n -> !Character.isLetter(n)),
    ALPHANUM(n -> !Character.isLetterOrDigit(n)),
    FRAGMENT(n -> !CodepointHelper.isFragment(n)),
    IFRAGMENT(n -> !CodepointHelper.is_ifragment(n)),
    PATH(n -> !CodepointHelper.isPath(n)),
    IPATH(n -> !CodepointHelper.is_ipath(n)),
    IUSERINFO(n -> !CodepointHelper.is_iuserinfo(n)),
    USERINFO(n -> !CodepointHelper.isUserInfo(n)),
    QUERY(n -> !CodepointHelper.isQuery(n)),
    IQUERY(n -> !CodepointHelper.is_iquery(n)),
    SCHEME(n -> !CodepointHelper.isScheme(n)),
    PATHNODELIMS(n -> !CodepointHelper.isPathNoDelims(n)),
    IPATHNODELIMS(n -> !CodepointHelper.is_ipathnodelims(n)),
    IPATHNODELIMS_SEG(n -> !CodepointHelper.is_ipathnodelims(n) && n != 64 && n != 58),
    IREGNAME(n -> !CodepointHelper.is_iregname(n)),
    IHOST(n -> !CodepointHelper.is_ihost(n)),
    IPRIVATE(n -> !CodepointHelper.is_iprivate(n)),
    RESERVED(n -> !CodepointHelper.isReserved(n)),
    IUNRESERVED(n -> !CodepointHelper.is_iunreserved(n)),
    UNRESERVED(n -> !CodepointHelper.isUnreserved(n)),
    SCHEMESPECIFICPART(n -> !CodepointHelper.is_iunreserved(n) && !CodepointHelper.isReserved(n) && !CodepointHelper.is_iprivate(n) && !CodepointHelper.isPctEnc(n) && n != 35),
    AUTHORITY(n -> !CodepointHelper.is_regname(n) && !CodepointHelper.isUserInfo(n) && !CodepointHelper.isGenDelim(n)),
    ASCIISANSCRLF(n -> !CodepointHelper.inRange(n, 1, 9) && !CodepointHelper.inRange(n, 14, 127)),
    PCT(n -> !CodepointHelper.isPctEnc(n)),
    STD3ASCIIRULES(n -> !CodepointHelper.inRange(n, 0, 44) && !CodepointHelper.inRange(n, 46, 47) && !CodepointHelper.inRange(n, 58, 64) && !CodepointHelper.inRange(n, 91, 94) && !CodepointHelper.inRange(n, 96, 96) && !CodepointHelper.inRange(n, 123, 127));

    private final IntPredicate m_aFilter;

    private ECodepointProfile(IntPredicate intPredicate) {
        this.m_aFilter = intPredicate;
    }

    @Nonnull
    public IntPredicate getFilter() {
        return this.m_aFilter;
    }

    public boolean check(int n) {
        return this.m_aFilter.test(n);
    }
}

