/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.text.display;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.ArrayHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.commons.text.display.IHasDisplayText;
import saoui.shade.com.helger.commons.text.util.TextHelper;

@Immutable
public class HasDisplayTextWithArgs
implements IHasDisplayText {
    private final IHasDisplayText m_aParentText;
    private final Object[] m_aArgs;

    public HasDisplayTextWithArgs(@Nonnull IHasDisplayText iHasDisplayText, Object ... objectArray) {
        this.m_aParentText = ValueEnforcer.notNull(iHasDisplayText, "ParentText");
        this.m_aArgs = ValueEnforcer.notEmpty(objectArray, "Arguments");
    }

    @Nonnull
    public IHasDisplayText getParentText() {
        return this.m_aParentText;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public Object[] getAllArgs() {
        return ArrayHelper.getCopy(this.m_aArgs);
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        String string = this.m_aParentText.getDisplayText(locale);
        return TextHelper.getFormattedText(string, this.m_aArgs);
    }

    public String toString() {
        return new ToStringGenerator(this).append("parentText", this.m_aParentText).append("args", this.m_aArgs).getToString();
    }
}

