/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.text.resolve;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.annotation.DevelopersNote;
import saoui.shade.com.helger.commons.text.IHasText;
import saoui.shade.com.helger.commons.text.IHasTextWithArgs;
import saoui.shade.com.helger.commons.text.resolve.EnumTextResolverWithPropertiesOverrideAndFallback;

@ThreadSafe
public final class DefaultTextResolver
extends EnumTextResolverWithPropertiesOverrideAndFallback {
    private static boolean s_bDefaultInstantiated = false;

    private DefaultTextResolver() {
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static DefaultTextResolver getInstance() {
        DefaultTextResolver defaultTextResolver = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return defaultTextResolver;
    }

    @Nullable
    public static String getTextStatic(@Nonnull Enum<?> enum_, @Nonnull IHasText iHasText, @Nonnull Locale locale) {
        return DefaultTextResolver.getInstance().getText(enum_, iHasText, locale);
    }

    @Nullable
    @Deprecated
    @DevelopersNote(value="Use getTextStatic instead when no argument is needed!")
    public static String getTextWithArgsStatic(@Nonnull Enum<?> enum_, @Nonnull IHasTextWithArgs iHasTextWithArgs, @Nonnull Locale locale) {
        return DefaultTextResolver.getTextStatic(enum_, iHasTextWithArgs, locale);
    }

    @Nullable
    public static String getTextWithArgsStatic(@Nonnull Enum<?> enum_, @Nonnull IHasTextWithArgs iHasTextWithArgs, @Nonnull Locale locale, Object ... objectArray) {
        return DefaultTextResolver.getInstance().getTextWithArgs(enum_, iHasTextWithArgs, locale, objectArray);
    }

    private static final class SingletonHolder {
        private static final DefaultTextResolver INSTANCE = new DefaultTextResolver();

        private SingletonHolder() {
        }
    }
}

