/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.text.util;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class ABNF {
    public static final int CHECK_RANGE_MIN_INCL = 0;
    public static final int CHECK_RANGE_MAX_INCL = 127;
    private static final int BIT_ALPHA = 1;
    private static final int BIT_BIT = 2;
    private static final int BIT_CHAR = 4;
    private static final int BIT_CR = 8;
    private static final int BIT_CTL = 16;
    private static final int BIT_DIGIT = 32;
    private static final int BIT_DQUOTE = 64;
    private static final int BIT_HEXDIGIT = 128;
    private static final int BIT_HTAB = 256;
    private static final int BIT_LF = 512;
    private static final int BIT_SP = 1024;
    private static final int BIT_VCHAR = 2048;
    private static final int BIT_WSP = 4096;
    private static final int BIT_HEXDIGIT_CI = 0x10000000;
    private static final int[] BITS = new int[]{16, 20, 20, 20, 20, 20, 20, 20, 20, 4372, 532, 20, 20, 28, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 5124, 2052, 2116, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 268437670, 268437670, 268437668, 268437668, 268437668, 268437668, 268437668, 268437668, 268437668, 268437668, 2052, 2052, 2052, 2052, 2052, 2052, 2052, 268437637, 268437637, 268437637, 268437637, 268437637, 268437637, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2052, 2052, 2052, 2052, 268437509, 268437509, 268437509, 268437509, 268437509, 268437509, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2053, 2052, 2052, 2052, 2052, 20};
    private static final ABNF INSTANCE;

    private ABNF() {
    }

    private static boolean _isBitSet(int n, int n2) {
        return n >= 0 && n <= 127 && (BITS[n] & n2) == n2;
    }

    public static boolean isAlpha(int n) {
        return ABNF._isBitSet(n, 1);
    }

    public static boolean isBit(int n) {
        return ABNF._isBitSet(n, 2);
    }

    public static boolean isChar(int n) {
        return ABNF._isBitSet(n, 4);
    }

    public static boolean isCR(int n) {
        return ABNF._isBitSet(n, 8);
    }

    public static boolean isCtl(int n) {
        return ABNF._isBitSet(n, 16);
    }

    public static boolean isDigit(int n) {
        return ABNF._isBitSet(n, 32);
    }

    public static boolean isDQuote(int n) {
        return ABNF._isBitSet(n, 64);
    }

    public static boolean isHexDigit(int n) {
        return ABNF._isBitSet(n, 128);
    }

    public static boolean isHexDigitCaseInsensitive(int n) {
        return ABNF._isBitSet(n, 0x10000000);
    }

    public static boolean isHTab(int n) {
        return ABNF._isBitSet(n, 256);
    }

    public static boolean isLF(int n) {
        return ABNF._isBitSet(n, 512);
    }

    public static boolean isOctet(int n) {
        return n >= 0 && n <= 255;
    }

    public static boolean isSP(int n) {
        return ABNF._isBitSet(n, 1024);
    }

    public static boolean isVChar(int n) {
        return ABNF._isBitSet(n, 2048);
    }

    public static boolean isWSP(int n) {
        return ABNF._isBitSet(n, 4096);
    }

    static {
        if (BITS.length != 128) {
            throw new IllegalStateException("Bits array has an invalid length!");
        }
        INSTANCE = new ABNF();
    }
}

