/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.thirdparty;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.commons.thirdparty.ILicense;
import saoui.shade.com.helger.commons.thirdparty.IThirdPartyModule;
import saoui.shade.com.helger.commons.version.Version;

@Immutable
public final class ThirdPartyModule
implements IThirdPartyModule {
    public static final boolean DEFAULT_OPTIONAL = false;
    private final String m_sDisplayName;
    private final String m_sCopyrightOwner;
    private final ILicense m_aLicense;
    private final Version m_aVersion;
    private final String m_sWebSiteURL;
    private final boolean m_bOptional;

    public ThirdPartyModule(@Nonnull IThirdPartyModule iThirdPartyModule, boolean bl) {
        this(iThirdPartyModule.getDisplayName(), iThirdPartyModule.getCopyrightOwner(), iThirdPartyModule.getLicense(), iThirdPartyModule.getVersion(), iThirdPartyModule.getWebSiteURL(), bl);
    }

    public ThirdPartyModule(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ILicense iLicense) {
        this(string, string2, iLicense, false);
    }

    public ThirdPartyModule(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ILicense iLicense, boolean bl) {
        this(string, string2, iLicense, null, null, bl);
    }

    public ThirdPartyModule(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ILicense iLicense, @Nullable Version version, @Nullable String string3) {
        this(string, string2, iLicense, version, string3, false);
    }

    public ThirdPartyModule(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ILicense iLicense, @Nullable Version version, @Nullable String string3, boolean bl) {
        this.m_sDisplayName = ValueEnforcer.notEmpty(string, "DisplayName");
        this.m_sCopyrightOwner = ValueEnforcer.notEmpty(string2, "CopyrightOwner");
        this.m_aLicense = ValueEnforcer.notNull(iLicense, "License");
        this.m_aVersion = version;
        this.m_sWebSiteURL = string3;
        this.m_bOptional = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getCopyrightOwner() {
        return this.m_sCopyrightOwner;
    }

    @Override
    @Nonnull
    public ILicense getLicense() {
        return this.m_aLicense;
    }

    @Override
    @Nullable
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    @Nullable
    public String getWebSiteURL() {
        return this.m_sWebSiteURL;
    }

    @Override
    public boolean isOptional() {
        return this.m_bOptional;
    }

    @Override
    @Nonnull
    public ThirdPartyModule getAsOptionalCopy() {
        if (this.m_bOptional) {
            return this;
        }
        return new ThirdPartyModule(this, true);
    }

    @Override
    @Nonnull
    public ThirdPartyModule getAsNonOptionalCopy() {
        if (!this.m_bOptional) {
            return this;
        }
        return new ThirdPartyModule(this, false);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ThirdPartyModule thirdPartyModule = (ThirdPartyModule)object;
        return this.m_sDisplayName.equals(thirdPartyModule.m_sDisplayName) && this.m_sCopyrightOwner.equals(thirdPartyModule.m_sCopyrightOwner) && this.m_aLicense.equals(thirdPartyModule.m_aLicense) && EqualsHelper.equals(this.m_aVersion, thirdPartyModule.m_aVersion) && EqualsHelper.equals(this.m_sWebSiteURL, thirdPartyModule.m_sWebSiteURL) && this.m_bOptional == thirdPartyModule.m_bOptional;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sDisplayName).append(this.m_sCopyrightOwner).append(this.m_aLicense).append(this.m_aVersion).append(this.m_sWebSiteURL).append(this.m_bOptional).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("displayName", this.m_sDisplayName).append("copyrightOwner", this.m_sCopyrightOwner).append("license", this.m_aLicense).appendIfNotNull("version", this.m_aVersion).appendIfNotNull("website", this.m_sWebSiteURL).append("optional", this.m_bOptional).getToString();
    }
}

