/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.thirdparty;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ELockType;
import saoui.shade.com.helger.commons.annotation.MustBeLocked;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsOrderedSet;
import saoui.shade.com.helger.commons.concurrent.SimpleReadWriteLock;
import saoui.shade.com.helger.commons.lang.ServiceLoaderHelper;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.thirdparty.IThirdPartyModule;
import saoui.shade.com.helger.commons.thirdparty.IThirdPartyModuleProviderSPI;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public final class ThirdPartyModuleRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyModuleRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedSet<IThirdPartyModule> m_aModules = new CommonsLinkedHashSet<IThirdPartyModule>();

    private ThirdPartyModuleRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static ThirdPartyModuleRegistry getInstance() {
        ThirdPartyModuleRegistry thirdPartyModuleRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return thirdPartyModuleRegistry;
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    private EChange _registerThirdPartyModule(@Nonnull IThirdPartyModule iThirdPartyModule) {
        ValueEnforcer.notNull(iThirdPartyModule, "Module");
        return this.m_aModules.addObject(iThirdPartyModule);
    }

    @Nonnull
    public EChange registerThirdPartyModule(@Nonnull IThirdPartyModule iThirdPartyModule) {
        return this.m_aRWLock.writeLockedGet(() -> this._registerThirdPartyModule(iThirdPartyModule));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IThirdPartyModule> getAllRegisteredThirdPartyModules() {
        return this.m_aRWLock.readLockedGet(this.m_aModules::getClone);
    }

    @Nonnegative
    public int getRegisteredThirdPartyModuleCount() {
        return this.m_aRWLock.readLockedInt(this.m_aModules::size);
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aModules.clear();
            for (IThirdPartyModuleProviderSPI iThirdPartyModuleProviderSPI : ServiceLoaderHelper.getAllSPIImplementations(IThirdPartyModuleProviderSPI.class)) {
                IThirdPartyModule[] iThirdPartyModuleArray = iThirdPartyModuleProviderSPI.getAllThirdPartyModules();
                if (iThirdPartyModuleArray == null) continue;
                for (IThirdPartyModule iThirdPartyModule : iThirdPartyModuleArray) {
                    this._registerThirdPartyModule(iThirdPartyModule);
                }
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + ThirdPartyModuleRegistry.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final ThirdPartyModuleRegistry INSTANCE = new ThirdPartyModuleRegistry();

        private SingletonHolder() {
        }
    }
}

