/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.timing;

import java.time.Duration;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.state.IStoppable;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@NotThreadSafe
public class StopWatch
implements IStoppable {
    private long m_nStartDT = 0L;
    private long m_nDurationNanos = 0L;

    protected StopWatch(boolean bl) {
        if (bl) {
            this.start();
        }
    }

    @Nonnull
    public EChange reset() {
        if (this.m_nDurationNanos == 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nDurationNanos = 0L;
        return EChange.CHANGED;
    }

    protected static final long getCurrentNanoTime() {
        return System.nanoTime();
    }

    @Nonnull
    public final EChange start() {
        if (this.m_nStartDT > 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nStartDT = StopWatch.getCurrentNanoTime();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange stop() {
        if (this.m_nStartDT == 0L) {
            return EChange.UNCHANGED;
        }
        long l = StopWatch.getCurrentNanoTime();
        this.m_nDurationNanos += l - this.m_nStartDT;
        this.m_nStartDT = 0L;
        return EChange.CHANGED;
    }

    public void restart() {
        this.stop();
        this.reset();
        this.start();
    }

    public boolean isStarted() {
        return this.m_nStartDT > 0L;
    }

    public boolean isStopped() {
        return this.m_nStartDT == 0L;
    }

    @Nonnegative
    public long getNanos() {
        return this.m_nDurationNanos;
    }

    @Nonnegative
    public long getMillis() {
        return this.m_nDurationNanos / 1000000L;
    }

    @Nonnegative
    @Deprecated
    public long getSeconds() {
        return this.m_nDurationNanos / 1000000000L;
    }

    @Nonnull
    public Duration getDuration() {
        return Duration.ofNanos(this.m_nDurationNanos);
    }

    @Nonnegative
    @Deprecated
    public long stopAndGetNanos() {
        this.stop();
        return this.getNanos();
    }

    @Nonnegative
    public long stopAndGetMillis() {
        this.stop();
        return this.getMillis();
    }

    @Nonnegative
    @Deprecated
    public long stopAndGetSeconds() {
        this.stop();
        return this.getSeconds();
    }

    @Nonnull
    public Duration stopAndGetDuration() {
        this.stop();
        return this.getDuration();
    }

    @Nonnull
    public Duration getLapDuration() {
        this.stop();
        Duration duration = this.getDuration();
        this.start();
        return duration;
    }

    public String toString() {
        return new ToStringGenerator(this).append("StartDT", this.m_nStartDT).append("DurationNanos", this.m_nDurationNanos).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static StopWatch createdStarted() {
        return new StopWatch(true);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static StopWatch createdStopped() {
        return new StopWatch(false);
    }

    @Nonnull
    public static Duration runMeasured(@Nonnull Runnable runnable) {
        StopWatch stopWatch = StopWatch.createdStarted();
        runnable.run();
        return stopWatch.stopAndGetDuration();
    }
}

