/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.traits;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsOrderedSet;
import saoui.shade.com.helger.commons.datetime.PDTFromString;
import saoui.shade.com.helger.commons.lang.GenericReflection;
import saoui.shade.com.helger.commons.typeconvert.TypeConverter;

@FunctionalInterface
public interface IGetterByKeyTrait<KEYTYPE> {
    @Nullable
    public Object getValue(@Nullable KEYTYPE var1);

    @Nullable
    default public Class<?> getValueClass(@Nullable KEYTYPE KEYTYPE) {
        Object object = this.getValue(KEYTYPE);
        return object == null ? null : object.getClass();
    }

    default public boolean containsNonNullValue(@Nullable KEYTYPE KEYTYPE) {
        return this.getValue(KEYTYPE) != null;
    }

    default public boolean containsNullValue(@Nullable KEYTYPE KEYTYPE) {
        return this.getValue(KEYTYPE) == null;
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable KEYTYPE KEYTYPE) {
        return (T)GenericReflection.uncheckedCast(this.getValue(KEYTYPE));
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable KEYTYPE KEYTYPE, @Nullable T t) {
        Object object = this.getValue(KEYTYPE);
        return (T)(object == null ? t : GenericReflection.uncheckedCast(object));
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<T> clazz) {
        return clazz.cast(this.getValue(KEYTYPE));
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable KEYTYPE KEYTYPE, @Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue(KEYTYPE);
        return object == null ? t : clazz.cast(object);
    }

    @Nullable
    default public <T> T getSafeCastedValue(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<T> clazz) {
        return this.getSafeCastedValue(KEYTYPE, null, clazz);
    }

    default public void onSafeCastError(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<?> clazz, @Nonnull Object object) {
    }

    @Nullable
    default public <T> T getSafeCastedValue(@Nullable KEYTYPE KEYTYPE, @Nullable T t, @Nonnull Class<T> clazz) {
        T t2;
        Object object = this.getValue(KEYTYPE);
        T t3 = t2 = object != null && clazz.isAssignableFrom(object.getClass()) ? clazz.cast(object) : t;
        if (t2 == null && object != null) {
            this.onSafeCastError(KEYTYPE, clazz, object);
        }
        return t2;
    }

    @Nullable
    default public <T> T getConvertedValue(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<T> clazz) {
        return TypeConverter.convert(this.getValue(KEYTYPE), clazz);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nullable KEYTYPE KEYTYPE, @Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue(KEYTYPE);
        return object == null ? t : TypeConverter.convert(object, clazz, t);
    }

    default public boolean getAsBoolean(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToBoolean(this.getValue(KEYTYPE));
    }

    default public boolean getAsBoolean(@Nullable KEYTYPE KEYTYPE, boolean bl) {
        return TypeConverter.convertToBoolean(this.getValue(KEYTYPE), bl);
    }

    default public byte getAsByte(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToByte(this.getValue(KEYTYPE));
    }

    default public byte getAsByte(@Nullable KEYTYPE KEYTYPE, byte by) {
        return TypeConverter.convertToByte(this.getValue(KEYTYPE), by);
    }

    default public char getAsChar(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToChar(this.getValue(KEYTYPE));
    }

    default public char getAsChar(@Nullable KEYTYPE KEYTYPE, char c) {
        return TypeConverter.convertToChar(this.getValue(KEYTYPE), c);
    }

    default public double getAsDouble(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToDouble(this.getValue(KEYTYPE));
    }

    default public double getAsDouble(@Nullable KEYTYPE KEYTYPE, double d) {
        return TypeConverter.convertToDouble(this.getValue(KEYTYPE), d);
    }

    default public float getAsFloat(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToFloat(this.getValue(KEYTYPE));
    }

    default public float getAsFloat(@Nullable KEYTYPE KEYTYPE, float f) {
        return TypeConverter.convertToFloat(this.getValue(KEYTYPE), f);
    }

    default public int getAsInt(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToInt(this.getValue(KEYTYPE));
    }

    default public int getAsInt(@Nullable KEYTYPE KEYTYPE, int n) {
        return TypeConverter.convertToInt(this.getValue(KEYTYPE), n);
    }

    default public long getAsLong(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToLong(this.getValue(KEYTYPE));
    }

    default public long getAsLong(@Nullable KEYTYPE KEYTYPE, long l) {
        return TypeConverter.convertToLong(this.getValue(KEYTYPE), l);
    }

    default public short getAsShort(@Nullable KEYTYPE KEYTYPE) {
        return TypeConverter.convertToShort(this.getValue(KEYTYPE));
    }

    default public short getAsShort(@Nullable KEYTYPE KEYTYPE, short s) {
        return TypeConverter.convertToShort(this.getValue(KEYTYPE), s);
    }

    @Nullable
    default public String getAsString(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, String.class);
    }

    @Nullable
    default public String getAsString(@Nullable KEYTYPE KEYTYPE, @Nullable String string) {
        return this.getConvertedValue(KEYTYPE, string, String.class);
    }

    @Nullable
    default public char[] getAsCharArray(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, char[].class);
    }

    @Nullable
    default public char[] getAsCharArray(@Nullable KEYTYPE KEYTYPE, @Nullable char[] cArray) {
        return this.getConvertedValue(KEYTYPE, cArray, char[].class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, BigDecimal.class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nullable KEYTYPE KEYTYPE, @Nullable BigDecimal bigDecimal) {
        return this.getConvertedValue(KEYTYPE, bigDecimal, BigDecimal.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, BigInteger.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nullable KEYTYPE KEYTYPE, @Nullable BigInteger bigInteger) {
        return this.getConvertedValue(KEYTYPE, bigInteger, BigInteger.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, LocalDate.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nullable KEYTYPE KEYTYPE, @Nullable LocalDate localDate) {
        return this.getConvertedValue(KEYTYPE, localDate, LocalDate.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, LocalTime.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nullable KEYTYPE KEYTYPE, @Nullable LocalTime localTime) {
        return this.getConvertedValue(KEYTYPE, localTime, LocalTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, LocalDateTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nullable KEYTYPE KEYTYPE, @Nullable LocalDateTime localDateTime) {
        return this.getConvertedValue(KEYTYPE, localDateTime, LocalDateTime.class);
    }

    @Nullable
    default public byte[] getAsByteArray(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, byte[].class);
    }

    @Nullable
    default public Boolean getAsBooleanObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Boolean.class);
    }

    @Nullable
    default public Byte getAsByteObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Byte.class);
    }

    @Nullable
    default public Character getAsCharObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Character.class);
    }

    @Nullable
    default public Double getAsDoubleObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Double.class);
    }

    @Nullable
    default public Float getAsFloatObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Float.class);
    }

    @Nullable
    default public Integer getAsIntObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Integer.class);
    }

    @Nullable
    default public Long getAsLongObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Long.class);
    }

    @Nullable
    default public Short getAsShortObj(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Short.class);
    }

    @Nullable
    default public Blob getAsSqlBlob(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Blob.class);
    }

    @Nullable
    default public Clob getAsSqlClob(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Clob.class);
    }

    @Nullable
    default public Date getAsSqlDate(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Date.class);
    }

    @Nullable
    default public NClob getAsSqlNClob(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, NClob.class);
    }

    @Nullable
    default public RowId getAsSqlRowId(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, RowId.class);
    }

    @Nullable
    default public Time getAsSqlTime(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Time.class);
    }

    @Nullable
    default public Timestamp getAsSqlTimestamp(@Nullable KEYTYPE KEYTYPE) {
        return this.getConvertedValue(KEYTYPE, null, Timestamp.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nullable KEYTYPE KEYTYPE, @Nonnull Locale locale) {
        String string = this.getAsString(KEYTYPE);
        return PDTFromString.getLocalDateFromString(string, locale);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nullable KEYTYPE KEYTYPE, @Nonnull Locale locale) {
        String string = this.getAsString(KEYTYPE);
        return PDTFromString.getLocalTimeFromString(string, locale);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nullable KEYTYPE KEYTYPE, @Nonnull Locale locale) {
        String string = this.getAsString(KEYTYPE);
        return PDTFromString.getLocalDateTimeFromString(string, locale);
    }

    @Nullable
    default public ICommonsList<String> getAsStringList(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsStringList(KEYTYPE, null);
    }

    @Nullable
    default public ICommonsList<String> getAsStringList(@Nullable KEYTYPE KEYTYPE, @Nullable ICommonsList<String> iCommonsList) {
        Object object = this.getValue(KEYTYPE);
        if (object != null) {
            if (object instanceof String[]) {
                return new CommonsArrayList<String>((String[])object);
            }
            if (object instanceof String) {
                return new CommonsArrayList<String>((String)object);
            }
        }
        return iCommonsList;
    }

    @Nullable
    default public ICommonsOrderedSet<String> getAsStringSet(@Nullable KEYTYPE KEYTYPE) {
        return this.getAsStringSet(KEYTYPE, null);
    }

    @Nullable
    default public ICommonsOrderedSet<String> getAsStringSet(@Nullable KEYTYPE KEYTYPE, @Nullable ICommonsOrderedSet<String> iCommonsOrderedSet) {
        Object object = this.getValue(KEYTYPE);
        if (object != null) {
            if (object instanceof String[]) {
                return new CommonsLinkedHashSet<String>((String[])object);
            }
            if (object instanceof String) {
                return new CommonsLinkedHashSet<String>((String)object);
            }
        }
        return iCommonsOrderedSet;
    }

    default public boolean hasStringValue(@Nullable KEYTYPE KEYTYPE, @Nullable String string) {
        return this.hasStringValue(KEYTYPE, string, false);
    }

    default public boolean hasStringValue(@Nullable KEYTYPE KEYTYPE, @Nullable String string, boolean bl) {
        String string2 = this.getAsString(KEYTYPE);
        return string2 == null ? bl : string2.equals(string);
    }
}

