/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.traits;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.lang.GenericReflection;
import saoui.shade.com.helger.commons.typeconvert.TypeConverter;

@FunctionalInterface
public interface IGetterDirectTrait {
    @Nullable
    public Object getValue();

    @Nullable
    default public Class<?> getValueClass() {
        Object object = this.getValue();
        return object == null ? null : object.getClass();
    }

    default public boolean hasValue() {
        return this.getValue() != null;
    }

    default public boolean hasNoValue() {
        return this.getValue() == null;
    }

    @Nullable
    default public <T> T getCastedValue() {
        return (T)GenericReflection.uncheckedCast(this.getValue());
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable T t) {
        Object object = this.getValue();
        return (T)(object == null ? t : GenericReflection.uncheckedCast(object));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnull Class<T> clazz) {
        return clazz.cast(this.getValue());
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue();
        return object == null ? t : clazz.cast(object);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnull Class<T> clazz) {
        return TypeConverter.convert(this.getValue(), clazz);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue();
        return object == null ? t : TypeConverter.convert(object, clazz, t);
    }

    default public boolean getAsBoolean() {
        return TypeConverter.convertToBoolean(this.getValue());
    }

    default public boolean getAsBoolean(boolean bl) {
        return TypeConverter.convertToBoolean(this.getValue(), bl);
    }

    default public byte getAsByte() {
        return TypeConverter.convertToByte(this.getValue());
    }

    default public byte getAsByte(byte by) {
        return TypeConverter.convertToByte(this.getValue(), by);
    }

    default public char getAsChar() {
        return TypeConverter.convertToChar(this.getValue());
    }

    default public char getAsChar(char c) {
        return TypeConverter.convertToChar(this.getValue(), c);
    }

    default public double getAsDouble() {
        return TypeConverter.convertToDouble(this.getValue());
    }

    default public double getAsDouble(double d) {
        return TypeConverter.convertToDouble(this.getValue(), d);
    }

    default public float getAsFloat() {
        return TypeConverter.convertToFloat(this.getValue());
    }

    default public float getAsFloat(float f) {
        return TypeConverter.convertToFloat(this.getValue(), f);
    }

    default public int getAsInt() {
        return TypeConverter.convertToInt(this.getValue());
    }

    default public int getAsInt(int n) {
        return TypeConverter.convertToInt(this.getValue(), n);
    }

    default public long getAsLong() {
        return TypeConverter.convertToLong(this.getValue());
    }

    default public long getAsLong(long l) {
        return TypeConverter.convertToLong(this.getValue(), l);
    }

    default public short getAsShort() {
        return TypeConverter.convertToShort(this.getValue());
    }

    default public short getAsShort(short s) {
        return TypeConverter.convertToShort(this.getValue(), s);
    }

    @Nullable
    default public String getAsString() {
        return this.getConvertedValue(null, String.class);
    }

    @Nullable
    default public String getAsString(@Nullable String string) {
        return this.getConvertedValue(string, String.class);
    }

    @Nullable
    default public char[] getAsCharArray() {
        return this.getConvertedValue(null, char[].class);
    }

    @Nullable
    default public char[] getAsCharArray(@Nullable char[] cArray) {
        return this.getConvertedValue(cArray, char[].class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal() {
        return this.getConvertedValue(null, BigDecimal.class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nullable BigDecimal bigDecimal) {
        return this.getConvertedValue(bigDecimal, BigDecimal.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger() {
        return this.getConvertedValue(null, BigInteger.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nullable BigInteger bigInteger) {
        return this.getConvertedValue(bigInteger, BigInteger.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate() {
        return this.getConvertedValue(null, LocalDate.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nullable LocalDate localDate) {
        return this.getConvertedValue(localDate, LocalDate.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime() {
        return this.getConvertedValue(null, LocalTime.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nullable LocalTime localTime) {
        return this.getConvertedValue(localTime, LocalTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime() {
        return this.getConvertedValue(null, LocalDateTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nullable LocalDateTime localDateTime) {
        return this.getConvertedValue(localDateTime, LocalDateTime.class);
    }

    @Nullable
    default public byte[] getAsByteArray() {
        return this.getConvertedValue(null, byte[].class);
    }

    @Nullable
    default public Boolean getAsBooleanObj() {
        return this.getConvertedValue(null, Boolean.class);
    }

    @Nullable
    default public Byte getAsByteObj() {
        return this.getConvertedValue(null, Byte.class);
    }

    @Nullable
    default public Character getAsCharObj() {
        return this.getConvertedValue(null, Character.class);
    }

    @Nullable
    default public Double getAsDoubleObj() {
        return this.getConvertedValue(null, Double.class);
    }

    @Nullable
    default public Float getAsFloatObj() {
        return this.getConvertedValue(null, Float.class);
    }

    @Nullable
    default public Integer getAsIntObj() {
        return this.getConvertedValue(null, Integer.class);
    }

    @Nullable
    default public Long getAsLongObj() {
        return this.getConvertedValue(null, Long.class);
    }

    @Nullable
    default public Short getAsShortObj() {
        return this.getConvertedValue(null, Short.class);
    }

    @Nullable
    default public Blob getAsSqlBlob() {
        return this.getConvertedValue(null, Blob.class);
    }

    @Nullable
    default public Clob getAsSqlClob() {
        return this.getConvertedValue(null, Clob.class);
    }

    @Nullable
    default public Date getAsSqlDate() {
        return this.getConvertedValue(null, Date.class);
    }

    @Nullable
    default public NClob getAsSqlNClob() {
        return this.getConvertedValue(null, NClob.class);
    }

    @Nullable
    default public RowId getAsSqlRowId() {
        return this.getConvertedValue(null, RowId.class);
    }

    @Nullable
    default public Time getAsSqlTime() {
        return this.getConvertedValue(null, Time.class);
    }

    @Nullable
    default public Timestamp getAsSqlTimestamp() {
        return this.getConvertedValue(null, Timestamp.class);
    }
}

