/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.url;

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableObject;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.lang.ICloneable;
import saoui.shade.com.helger.commons.lang.IHasSize;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.commons.url.ISimpleURL;
import saoui.shade.com.helger.commons.url.IURLParameterList;
import saoui.shade.com.helger.commons.url.URLData;
import saoui.shade.com.helger.commons.url.URLHelper;
import saoui.shade.com.helger.commons.url.URLParameter;
import saoui.shade.com.helger.commons.url.URLParameterDecoder;
import saoui.shade.com.helger.commons.url.URLParameterList;

@NotThreadSafe
public class SimpleURL
implements ISimpleURL,
ICloneable<SimpleURL>,
IURLParameterList<SimpleURL> {
    private String m_sPath;
    private final URLParameterList m_aParams = new URLParameterList();
    private String m_sAnchor;

    public SimpleURL() {
        this(URLData.EMPTY_URL_DATA);
    }

    public SimpleURL(@Nonnull URL uRL) {
        this(uRL, URLHelper.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull URL uRL, @Nonnull Charset charset) {
        this(uRL.toExternalForm(), charset);
    }

    public SimpleURL(@Nonnull URI uRI) {
        this(uRI, URLHelper.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull URI uRI, @Nonnull Charset charset) {
        this(uRI.toString(), charset);
    }

    public SimpleURL(@Nonnull String string) {
        this(string, URLHelper.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset) {
        this(URLHelper.getAsURLData(string, new URLParameterDecoder(charset)));
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map) {
        this(string);
        this.m_aParams.addAll(map);
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, URLHelper.CHARSET_URL_OBJ, map, string2);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, charset);
        this.m_aParams.addAll(map);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull String string, @Nullable Iterable<? extends URLParameter> iterable, @Nullable String string2) {
        this(string, URLHelper.CHARSET_URL_OBJ, iterable, string2);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Iterable<? extends URLParameter> iterable, @Nullable String string2) {
        this(string, charset);
        this.m_aParams.addAll(iterable);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull(iSimpleURL, "URL");
        this.m_sPath = iSimpleURL.getPath();
        this.m_aParams.addAll(iSimpleURL.params());
        this.m_sAnchor = iSimpleURL.getAnchor();
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    public SimpleURL setPath(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Path");
        this.m_sPath = string;
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final URLParameterList params() {
        return this.m_aParams;
    }

    @Override
    public boolean add(@Nonnull URLParameter uRLParameter) {
        return this.m_aParams.add(uRLParameter);
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    @Nonnull
    public SimpleURL setAnchor(@Nullable String string) {
        this.m_sAnchor = string;
        return this;
    }

    @Override
    @Nonnull
    public SimpleURL getClone() {
        return new SimpleURL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleURL simpleURL = (SimpleURL)object;
        return this.m_sPath.equals(simpleURL.m_sPath) && this.m_aParams.equals(simpleURL.m_aParams) && EqualsHelper.equals(this.m_sAnchor, simpleURL.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Iterable)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Path", this.m_sPath).appendIf("Params", this.m_aParams, IHasSize::isNotEmpty).appendIfNotNull("Anchor", this.m_sAnchor).getToString();
    }
}

