/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.codec.DecodeException;
import saoui.shade.com.helger.commons.codec.IDecoder;
import saoui.shade.com.helger.commons.codec.IEncoder;
import saoui.shade.com.helger.commons.codec.URLCodec;
import saoui.shade.com.helger.commons.collection.CollectionHelper;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.debug.GlobalDebug;
import saoui.shade.com.helger.commons.io.file.FilenameHelper;
import saoui.shade.com.helger.commons.io.resource.ClassPathResource;
import saoui.shade.com.helger.commons.io.stream.StreamHelper;
import saoui.shade.com.helger.commons.lang.ClassHelper;
import saoui.shade.com.helger.commons.lang.ClassLoaderHelper;
import saoui.shade.com.helger.commons.regex.RegExHelper;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.StringParser;
import saoui.shade.com.helger.commons.url.ISimpleURL;
import saoui.shade.com.helger.commons.url.IURLProtocol;
import saoui.shade.com.helger.commons.url.URLData;
import saoui.shade.com.helger.commons.url.URLParameter;
import saoui.shade.com.helger.commons.url.URLParameterEncoder;
import saoui.shade.com.helger.commons.url.URLParameterList;
import saoui.shade.com.helger.commons.url.URLProtocolRegistry;
import saoui.shade.com.helger.commons.wrapper.IMutableWrapper;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public final class URLHelper {
    public static final Charset CHARSET_URL_OBJ = StandardCharsets.UTF_8;
    public static final char QUESTIONMARK = '?';
    public static final String QUESTIONMARK_STR = Character.toString('?');
    public static final char AMPERSAND = '&';
    public static final String AMPERSAND_STR = Character.toString('&');
    public static final char EQUALS = '=';
    public static final String EQUALS_STR = Character.toString('=');
    public static final char HASH = '#';
    public static final String HASH_STR = Character.toString('#');
    public static final String PROTOCOL_FILE = "file";
    private static final Logger LOGGER = LoggerFactory.getLogger(URLHelper.class);
    private static char[] s_aCleanURLOld;
    private static char[][] s_aCleanURLNew;
    private static final boolean DEBUG_GET_IS = false;
    private static final URLCodec URL_CODEC;
    private static final URLHelper INSTANCE;
    @RegEx
    public static final String REGEX_URN = "^\\Qurn:\\E[a-zA-Z0-9][a-zA-Z0-9-]{0,31}\\Q:\\E[a-zA-Z0-9()+,\\-.:=@;$_!*'%/?#]+$";

    private URLHelper() {
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string) {
        return URLHelper.urlDecode(string, CHARSET_URL_OBJ);
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Value");
        try {
            return URL_CODEC.getDecodedAsString(string, charset);
        }
        catch (DecodeException decodeException) {
            throw new IllegalArgumentException(decodeException);
        }
    }

    @Nullable
    public static String urlDecodeOrNull(@Nonnull String string) {
        return URLHelper.urlDecodeOrNull(string, CHARSET_URL_OBJ);
    }

    @Nullable
    public static String urlDecodeOrNull(@Nullable String string, @Nonnull Charset charset) {
        return URLHelper.urlDecodeOrDefault(string, charset, null);
    }

    @Nullable
    public static String urlDecodeOrDefault(@Nonnull String string, @Nullable String string2) {
        return URLHelper.urlDecodeOrDefault(string, CHARSET_URL_OBJ, string2);
    }

    @Nullable
    public static String urlDecodeOrDefault(@Nullable String string, @Nonnull Charset charset, @Nullable String string2) {
        if (string != null) {
            try {
                return URL_CODEC.getDecodedAsString(string, charset);
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        return string2;
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string) {
        return URLHelper.urlEncode(string, CHARSET_URL_OBJ);
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Value");
        return URL_CODEC.getEncodedAsString(string, charset);
    }

    private static void _initCleanURL() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        StreamHelper.readStreamLines(ClassPathResource.getInputStream("codelists/cleanurl-data.dat"), StandardCharsets.UTF_8, string -> {
            if (string.length() > 0 && string.charAt(0) == '\"') {
                String[] stringArray = StringHelper.getExplodedArray('=', string, 2);
                String string2 = StringHelper.trimStartAndEnd(stringArray[0], '\"');
                if (string2.startsWith("&#")) {
                    string2 = StringHelper.trimStartAndEnd(string2, "&#", ";");
                    string2 = Character.toString((char)StringParser.parseInt(string2, -1));
                }
                String string3 = StringHelper.trimStartAndEnd(stringArray[1], '\"');
                commonsLinkedHashMap.put(string2, string3);
            }
        });
        s_aCleanURLOld = new char[commonsLinkedHashMap.size()];
        s_aCleanURLNew = new char[commonsLinkedHashMap.size()][];
        int n = 0;
        for (Map.Entry entry : commonsLinkedHashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            if (string2.length() != 1) {
                throw new IllegalStateException("Clean URL source character has an invalid length: " + string2.length());
            }
            URLHelper.s_aCleanURLOld[n] = string2.charAt(0);
            URLHelper.s_aCleanURLNew[n] = ((String)entry.getValue()).toCharArray();
            ++n;
        }
    }

    @Nullable
    public static String getCleanURLPartWithoutUmlauts(@Nullable String string) {
        if (s_aCleanURLOld == null) {
            URLHelper._initCleanURL();
        }
        char[] cArray = StringHelper.replaceMultiple(string, s_aCleanURLOld, s_aCleanURLNew);
        return new String(cArray);
    }

    @Nonnull
    public static ISimpleURL getAsURLData(@Nonnull String string) {
        return URLHelper.getAsURLData(string, null);
    }

    @Nonnull
    public static ISimpleURL getAsURLData(@Nonnull String string, @Nullable IDecoder<String, String> iDecoder) {
        String string2;
        String string3;
        String string4;
        block9: {
            ValueEnforcer.notNull(string, "Href");
            string4 = string.trim();
            IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string4);
            if (iURLProtocol != null && !iURLProtocol.allowsForQueryParameters()) {
                return new URLData(string4, null, null);
            }
            if (GlobalDebug.isDebugMode() && iURLProtocol != null) {
                try {
                    new URL(string4);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!LOGGER.isWarnEnabled()) break block9;
                    LOGGER.warn("java.net.URL claims URL '" + string4 + "' to be invalid: " + malformedURLException.getMessage());
                }
            }
        }
        URLParameterList uRLParameterList = null;
        String string5 = string4;
        int n = string5.indexOf(35);
        if (n >= 0) {
            string3 = string5.substring(n + 1).trim();
            string5 = string5.substring(0, n).trim();
        } else {
            string3 = null;
        }
        int n2 = string5.indexOf(63);
        if (n2 >= 0) {
            String string6 = string5.substring(n2 + 1).trim();
            if (StringHelper.hasText(string6)) {
                uRLParameterList = URLHelper.getParsedQueryParameters(string6, iDecoder);
            }
            string2 = string5.substring(0, n2).trim();
        } else {
            string2 = string5;
        }
        return new URLData(string2, uRLParameterList, string3);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static URLParameterList getParsedQueryParameters(@Nullable String string, @Nullable IDecoder<String, String> iDecoder) {
        URLParameterList uRLParameterList = new URLParameterList();
        if (StringHelper.hasText(string)) {
            for (String string2 : StringHelper.getExploded('&', string)) {
                String string3;
                ICommonsList<String> iCommonsList;
                String string4;
                if (string2.length() <= 0 || !StringHelper.hasText(string4 = (String)(iCommonsList = StringHelper.getExploded('=', string2, 2)).get(0))) continue;
                String string5 = string3 = iCommonsList.size() == 2 ? (String)iCommonsList.get(1) : "";
                if (string3 == null) {
                    throw new IllegalArgumentException("parameter value may not be null");
                }
                if (iDecoder != null) {
                    uRLParameterList.add(iDecoder.getDecoded(string4), iDecoder.getDecoded(string3));
                    continue;
                }
                uRLParameterList.add(string4, string3);
            }
        }
        return uRLParameterList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static URLParameterList getParsedQueryParameters(@Nullable String string) {
        return URLHelper.getParsedQueryParameters(string, null);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        boolean bl = StringHelper.hasText(string);
        boolean bl2 = StringHelper.hasText(string2);
        boolean bl3 = StringHelper.hasText(string3);
        if (GlobalDebug.isDebugMode()) {
            if (bl) {
                if (string.contains(QUESTIONMARK_STR) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Path contains the question mark ('?') character: '" + string + "'");
                }
                if (string.contains(AMPERSAND_STR) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Path contains the ampersand ('&') character: '" + string + "'");
                }
                if (string.contains(HASH_STR) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Path contains the hash ('#') character: '" + string + "'");
                }
            }
            if (bl2 && string2.contains(QUESTIONMARK_STR) && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Query parameters contain the question mark ('?') character: '" + string2 + "'");
            }
            if (bl3 && string3.contains(HASH_STR) && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Anchor contains the hash ('#') character: '" + string3 + "'");
            }
        }
        if (!bl2 && !bl3) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(string);
        }
        if (bl2) {
            boolean bl4;
            boolean bl5 = bl4 = stringBuilder.indexOf(QUESTIONMARK_STR) >= 0;
            if (bl4) {
                char c = StringHelper.getLastChar(stringBuilder);
                if (c != '?' && c != '&') {
                    stringBuilder.append('&');
                }
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append(string2);
        }
        if (bl3) {
            if (StringHelper.getLastChar(stringBuilder) != '#') {
                stringBuilder.append('#');
            }
            stringBuilder.append(string3);
        }
        if (stringBuilder.length() == 0) {
            return QUESTIONMARK_STR;
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getQueryParametersAsString(@Nullable List<? extends URLParameter> list2, @Nullable IEncoder<String, String> iEncoder) {
        if (CollectionHelper.isEmpty(list2)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (URLParameter uRLParameter : list2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            uRLParameter.appendTo(stringBuilder, iEncoder);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getURLString(@Nonnull ISimpleURL iSimpleURL, @Nullable Charset charset) {
        return URLHelper.getURLString(iSimpleURL.getPath(), (List<? extends URLParameter>)iSimpleURL.params(), iSimpleURL.getAnchor(), charset);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable List<? extends URLParameter> list2, @Nullable String string2, @Nullable IEncoder<String, String> iEncoder) {
        return URLHelper.getURLString(string, URLHelper.getQueryParametersAsString(list2, iEncoder), string2);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable List<? extends URLParameter> list2, @Nullable String string2, @Nullable Charset charset) {
        URLParameterEncoder uRLParameterEncoder = charset == null ? null : new URLParameterEncoder(charset);
        return URLHelper.getURLString(string, URLHelper.getQueryParametersAsString(list2, uRLParameterEncoder), string2);
    }

    @Nullable
    public static URL getAsURL(@Nullable String string, boolean bl) {
        block3: {
            if (StringHelper.hasText(string)) {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!bl || !GlobalDebug.isDebugMode() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + string + "' to a URL!");
                }
            }
        }
        return null;
    }

    @Nullable
    public static URL getAsURL(@Nullable String string) {
        return URLHelper.getAsURL(string, true);
    }

    @Nullable
    public static URL getAsURL(@Nullable URI uRI) {
        block3: {
            if (uRI != null) {
                try {
                    return uRI.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!GlobalDebug.isDebugMode() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + uRI + "' to a URL!");
                }
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable String string) {
        block3: {
            if (StringHelper.hasText(string)) {
                try {
                    return new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!GlobalDebug.isDebugMode() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + string + "' to a URI!");
                }
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable URL uRL) {
        block3: {
            if (uRL != null) {
                try {
                    return uRL.toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!GlobalDebug.isDebugMode() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + uRL + "' to a URI!");
                }
            }
        }
        return null;
    }

    private static boolean _isTimeout(IOException iOException) {
        return iOException instanceof SocketTimeoutException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InputStream getInputStream(@Nonnull URL uRL, @CheckForSigned int n, @CheckForSigned int n2, @Nullable Consumer<? super URLConnection> consumer, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        ValueEnforcer.notNull(uRL, "URL");
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            URLConnection uRLConnection = uRL.openConnection();
            if (n >= 0) {
                uRLConnection.setConnectTimeout(n);
            }
            if (n2 >= 0) {
                uRLConnection.setReadTimeout(n2);
            }
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
            }
            uRLConnection.setUseCaches(false);
            if (consumer != null) {
                consumer.accept(uRLConnection);
            }
            if (uRLConnection instanceof JarURLConnection && (object = ((JarURLConnection)uRLConnection).getJarEntry()) != null) {
                if (((ZipEntry)object).isDirectory()) {
                    return null;
                }
                if (((ZipEntry)object).getSize() == 0L && ((ZipEntry)object).getCrc() == 0L) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Heuristically determined " + uRL + " to be a directory!");
                    }
                    return null;
                }
            }
            object = uRLConnection.getInputStream();
            return object;
        }
        catch (IOException iOException) {
            if (iMutableWrapper != null) {
                iMutableWrapper.set(iOException);
            } else if (URLHelper._isTimeout(iOException)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Timeout to open input stream for '" + uRL + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to open input stream for '" + uRL + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            }
            if (httpURLConnection != null) {
                InputStream inputStream = null;
                try {
                    inputStream = httpURLConnection.getErrorStream();
                    if (inputStream != null) {
                        byte[] byArray = new byte[1024];
                        while (inputStream.read(byArray) > 0) {
                        }
                    }
                }
                catch (IOException iOException2) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Failed to consume error stream for '" + uRL + "': " + iOException2.getClass().getName() + " - " + iOException2.getMessage());
                    }
                }
                finally {
                    StreamHelper.close(inputStream);
                }
            }
            return null;
        }
    }

    @Nonnull
    public static File getAsFile(@Nonnull URL uRL) {
        File file;
        String string;
        ValueEnforcer.notNull(uRL, "URL");
        ValueEnforcer.isEqual(PROTOCOL_FILE, uRL.getProtocol(), () -> "Not a file URL: " + uRL.toExternalForm());
        try {
            string = uRL.toURI().getSchemeSpecificPart();
            file = new File(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            string = uRL.getPath();
            file = new File(string);
        }
        if (FilenameHelper.startsWithPathSeparatorChar(string)) {
            file = file.getAbsoluteFile();
        }
        return file;
    }

    @Nullable
    public static File getAsFileOrNull(@Nonnull URL uRL) {
        if (uRL != null) {
            try {
                return URLHelper.getAsFile(uRL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URL getClassPathURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Path");
        URL uRL = ClassLoaderHelper.getResource(ClassLoaderHelper.getDefaultClassLoader(), string);
        if (uRL == null && (uRL = ClassHelper.getResource(URLHelper.class, string)) == null) {
            uRL = ClassLoaderHelper.getResource(ClassLoaderHelper.getSystemClassLoader(), string);
        }
        return uRL;
    }

    public static boolean isClassPathURLExisting(@Nonnull @Nonempty String string) {
        return URLHelper.getClassPathURL(string) != null;
    }

    public static boolean isClassPathURLExisting(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        return ClassLoaderHelper.getResource(classLoader, string) != null;
    }

    public static boolean isValidURN(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return RegExHelper.stringMatchesPattern(REGEX_URN, string);
    }

    static {
        URL_CODEC = new URLCodec();
        INSTANCE = new URLHelper();
    }
}

