/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.url;

import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsHashMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsCollection;
import saoui.shade.com.helger.commons.collection.impl.ICommonsMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsSet;
import saoui.shade.com.helger.commons.concurrent.SimpleReadWriteLock;
import saoui.shade.com.helger.commons.lang.ServiceLoaderHelper;
import saoui.shade.com.helger.commons.url.EURLProtocol;
import saoui.shade.com.helger.commons.url.ISimpleURL;
import saoui.shade.com.helger.commons.url.IURLProtocol;
import saoui.shade.com.helger.commons.url.IURLProtocolRegistrarSPI;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public final class URLProtocolRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLProtocolRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, IURLProtocol> m_aProtocols = new CommonsHashMap<String, IURLProtocol>();

    private URLProtocolRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static URLProtocolRegistry getInstance() {
        URLProtocolRegistry uRLProtocolRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return uRLProtocolRegistry;
    }

    public void registerProtocol(@Nonnull IURLProtocol iURLProtocol) {
        ValueEnforcer.notNull(iURLProtocol, "Protocol");
        String string = iURLProtocol.getProtocol();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aProtocols.containsKey(string)) {
                throw new IllegalArgumentException("Another handler for protocol '" + string + "' is already registered!");
            }
            this.m_aProtocols.put(string, iURLProtocol);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered new custom URL protocol: " + iURLProtocol);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<IURLProtocol> getAllProtocols() {
        return this.m_aRWLock.readLockedGet(this.m_aProtocols::copyOfValues);
    }

    @Nonnegative
    public int getRegisteredProtocolCount() {
        return this.m_aRWLock.readLockedInt(this.m_aProtocols::size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IURLProtocol getProtocol(@Nullable String string) {
        if (string == null) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            for (IURLProtocol iURLProtocol : this.m_aProtocols.values()) {
                if (!iURLProtocol.isUsedInURL(string)) continue;
                IURLProtocol iURLProtocol2 = iURLProtocol;
                return iURLProtocol2;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    public IURLProtocol getProtocol(@Nullable ISimpleURL iSimpleURL) {
        return iSimpleURL == null ? null : this.getProtocol(iSimpleURL.getPath());
    }

    public boolean hasKnownProtocol(@Nullable String string) {
        return this.getProtocol(string) != null;
    }

    public boolean hasKnownProtocol(@Nullable ISimpleURL iSimpleURL) {
        return this.getProtocol(iSimpleURL) != null;
    }

    @Nullable
    public String getWithoutProtocol(@Nullable String string) {
        IURLProtocol iURLProtocol = this.getProtocol(string);
        return iURLProtocol == null ? string : string.substring(iURLProtocol.getProtocol().length());
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aProtocols.clear();
            for (EURLProtocol eURLProtocol : EURLProtocol.values()) {
                this.m_aProtocols.put(eURLProtocol.getProtocol(), eURLProtocol);
            }
        });
        for (IURLProtocolRegistrarSPI iURLProtocolRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IURLProtocolRegistrarSPI.class)) {
            ICommonsSet<? extends IURLProtocol> iCommonsSet = iURLProtocolRegistrarSPI.getAllProtocols();
            if (iCommonsSet == null) continue;
            for (IURLProtocol iURLProtocol : iCommonsSet) {
                this.registerProtocol(iURLProtocol);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getRegisteredProtocolCount() + " URL protocols registered");
        }
    }

    private static final class SingletonHolder {
        private static final URLProtocolRegistry INSTANCE = new URLProtocolRegistry();

        private SingletonHolder() {
        }
    }
}

