/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.vendor;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.datetime.PDTFactory;
import saoui.shade.com.helger.commons.email.EmailAddressHelper;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.url.EURLProtocol;
import saoui.shade.com.helger.commons.url.IURLProtocol;
import saoui.shade.com.helger.commons.url.URLProtocolRegistry;

@NotThreadSafe
public final class VendorInfo {
    public static final String DEFAULT_VENDOR_LOCATION = "Vienna, Austria, Europe, World, Milky Way, Universe";
    public static final String DEFAULT_VENDOR_NAME = "Philip Helger";
    public static final String DEFAULT_VENDOR_URL_WITHOUT_PROTOCOL = "www.helger.com";
    public static final String DEFAULT_VENDOR_URL = "http://www.helger.com";
    public static final String VENDOR_PERSON_PHILIP = "Philip Helger";
    public static final String DEFAULT_VENDOR_EMAIL_SUFFIX = "@helger.com";
    public static final String DEFAULT_VENDOR_EMAIL = "office@helger.com";
    public static final int DEFAULT_INCEPTION_YEAR = 2014;
    private static final VendorInfo INSTANCE = new VendorInfo();
    private static String s_sVendorLocation = "Vienna, Austria, Europe, World, Milky Way, Universe";
    private static int s_nInceptionYear = 2014;
    private static String s_sVendorName = "Philip Helger";
    private static String s_sVendorURLWithoutProtocol = "www.helger.com";
    private static String s_sVendorURL = "http://www.helger.com";
    private static String s_sVendorEmailSuffix = "@helger.com";
    private static String s_sVendorEmail = "office@helger.com";

    private VendorInfo() {
    }

    @Nonnull
    public static String getVendorLocation() {
        return s_sVendorLocation;
    }

    public static void setVendorLocation(@Nonnull @Nonempty String string) {
        s_sVendorLocation = ValueEnforcer.notEmpty(string, "VendorLocation");
    }

    @Nonnegative
    public static int getInceptionYear() {
        return s_nInceptionYear;
    }

    public static void setInceptionYear(@Nonnegative int n) {
        s_nInceptionYear = ValueEnforcer.isGE0(n, "InceptionYear");
    }

    @Nonnull
    public static String getVendorName() {
        return s_sVendorName;
    }

    public static void setVendorName(@Nonnull @Nonempty String string) {
        s_sVendorName = ValueEnforcer.notEmpty(string, "VendorName");
    }

    @Nonnull
    public static String getVendorURLWithoutProtocol() {
        return s_sVendorURLWithoutProtocol;
    }

    @Nonnull
    public static String getVendorURL() {
        return s_sVendorURL;
    }

    public static void setVendorURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "VendorURL");
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string);
        if (iURLProtocol == null) {
            s_sVendorURLWithoutProtocol = string;
            s_sVendorURL = EURLProtocol.HTTP.getWithProtocol(string);
        } else {
            s_sVendorURLWithoutProtocol = string.substring(iURLProtocol.getProtocol().length());
            s_sVendorURL = string;
        }
    }

    @Nonnull
    public static String getVendorEmail() {
        return s_sVendorEmail;
    }

    @Nonnull
    public static String getVendorEmailSuffix() {
        return s_sVendorEmailSuffix;
    }

    public static void setVendorEmail(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "VendorEmail");
        ValueEnforcer.isTrue(EmailAddressHelper.isValid(string), () -> "Illegal vendor email: " + string);
        s_sVendorEmail = string;
        s_sVendorEmailSuffix = StringHelper.getFromFirstIncl(string, '@');
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getFileHeaderLines() {
        int n = PDTFactory.getCurrentYear();
        return new CommonsArrayList<String>("THIS FILE IS GENERATED - DO NOT EDIT", "", "Copyright", "", "Copyright (c) " + VendorInfo.getVendorName() + " " + VendorInfo.getInceptionYear() + " - " + n, VendorInfo.getVendorURL(), "", "All Rights Reserved", "Use, duplication or disclosure restricted by " + VendorInfo.getVendorName(), "", VendorInfo.getVendorLocation() + ", " + VendorInfo.getInceptionYear() + " - " + n);
    }
}

