/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.ws;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import saoui.shade.com.helger.commons.debug.GlobalDebug;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

public class HostnameVerifierVerifyAll
implements HostnameVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostnameVerifierVerifyAll.class);
    private final boolean m_bDebug;

    public HostnameVerifierVerifyAll() {
        this(GlobalDebug.isDebugMode());
    }

    public HostnameVerifierVerifyAll(boolean bl) {
        this.m_bDebug = bl;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        if (this.m_bDebug && LOGGER.isInfoEnabled()) {
            LOGGER.info("Hostname '" + string + "' is accepted by default in SSL session " + sSLSession + "!");
        }
        return true;
    }

    public String toString() {
        return new ToStringGenerator(this).append("debug", this.m_bDebug).getToString();
    }
}

