/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.lang.EnumHelper;
import saoui.shade.com.helger.commons.name.IHasName;
import saoui.shade.com.helger.css.ECSSMetaUnit;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSVersionAware;

public enum ECSSUnit implements IHasName,
ICSSVersionAware
{
    EM("em", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS10),
    EX("ex", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS10),
    PX("px", ECSSMetaUnit.ABSOLUTE_LENGTH, ECSSVersion.CSS10),
    CH("ch", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    REM("rem", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VW("vw", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VH("vh", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VMIN("vmin", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VMAX("vmax", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    LENGTH_IN("in", ECSSMetaUnit.ABSOLUTE_LENGTH, ECSSVersion.CSS10),
    LENGTH_CM("cm", ECSSMetaUnit.ABSOLUTE_LENGTH, ECSSVersion.CSS10),
    LENGTH_MM("mm", ECSSMetaUnit.ABSOLUTE_LENGTH, ECSSVersion.CSS10),
    LENGTH_Q("q", ECSSMetaUnit.ABSOLUTE_LENGTH, ECSSVersion.CSS30),
    LENGTH_PT("pt", ECSSMetaUnit.ABSOLUTE_LENGTH, ECSSVersion.CSS10),
    LENGTH_PC("pc", ECSSMetaUnit.ABSOLUTE_LENGTH, ECSSVersion.CSS10),
    PERCENTAGE("%", ECSSMetaUnit.PERCENTAGE, ECSSVersion.CSS10),
    ANGLE_DEG("deg", ECSSMetaUnit.ANGLE, ECSSVersion.CSS21),
    ANGLE_RAD("rad", ECSSMetaUnit.ANGLE, ECSSVersion.CSS21),
    ANGLE_GRAD("grad", ECSSMetaUnit.ANGLE, ECSSVersion.CSS21),
    ANGLE_TURN("turn", ECSSMetaUnit.ANGLE, ECSSVersion.CSS30),
    TIME_MS("ms", ECSSMetaUnit.TIME, ECSSVersion.CSS21),
    TIME_S("s", ECSSMetaUnit.TIME, ECSSVersion.CSS21),
    FREQ_HZ("hz", ECSSMetaUnit.FREQUENZY, ECSSVersion.CSS21),
    FREQ_KHZ("khz", ECSSMetaUnit.FREQUENZY, ECSSVersion.CSS21),
    DPI("dpi", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30),
    DPCM("dpcm", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30),
    DPPX("dppx", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30),
    FR("fr", ECSSMetaUnit.FLEX, ECSSVersion.CSS30);

    public static final ECSSUnit LENGTH_PX;
    private final String m_sName;
    private final ECSSMetaUnit m_eMetaUnit;
    private final ECSSVersion m_eVersion;

    private ECSSUnit(@Nonnull String string2, ECSSMetaUnit eCSSMetaUnit, ECSSVersion eCSSVersion) {
        this.m_sName = string2;
        this.m_eMetaUnit = eCSSMetaUnit;
        this.m_eVersion = eCSSVersion;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public ECSSMetaUnit getMetaUnit() {
        return this.m_eMetaUnit;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return this.m_eVersion;
    }

    @Nonnull
    @Nonempty
    public String format(int n) {
        return Integer.toString(n) + this.m_sName;
    }

    @Nonnull
    @Nonempty
    public String format(long l) {
        return Long.toString(l) + this.m_sName;
    }

    @Nonnull
    @Nonempty
    public String format(double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(16);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(d) + this.m_sName;
    }

    @Nonnull
    @Nonempty
    public String format(@Nonnull BigDecimal bigDecimal) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(16);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(bigDecimal) + this.m_sName;
    }

    @Nullable
    public static ECSSUnit getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(ECSSUnit.class, string);
    }

    @Nullable
    public static ECSSUnit getFromNameOrDefault(@Nullable String string, @Nullable ECSSUnit eCSSUnit) {
        return EnumHelper.getFromNameOrDefault(ECSSUnit.class, string, eCSSUnit);
    }

    @Nonnull
    @Nonempty
    public static String em(int n) {
        return EM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String em(double d) {
        return EM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String em(@Nonnull BigDecimal bigDecimal) {
        return EM.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String ex(int n) {
        return EX.format(n);
    }

    @Nonnull
    @Nonempty
    public static String ex(double d) {
        return EX.format(d);
    }

    @Nonnull
    @Nonempty
    public static String ex(@Nonnull BigDecimal bigDecimal) {
        return EX.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String px(int n) {
        return PX.format(n);
    }

    @Nonnull
    @Nonempty
    public static String px(double d) {
        return PX.format(d);
    }

    @Nonnull
    @Nonempty
    public static String px(@Nonnull BigDecimal bigDecimal) {
        return PX.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String rem(int n) {
        return REM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String rem(double d) {
        return REM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String rem(@Nonnull BigDecimal bigDecimal) {
        return REM.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String vw(int n) {
        return VW.format(n);
    }

    @Nonnull
    @Nonempty
    public static String vw(double d) {
        return VW.format(d);
    }

    @Nonnull
    @Nonempty
    public static String vw(@Nonnull BigDecimal bigDecimal) {
        return VW.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String vh(int n) {
        return VH.format(n);
    }

    @Nonnull
    @Nonempty
    public static String vh(double d) {
        return VH.format(d);
    }

    @Nonnull
    @Nonempty
    public static String vh(@Nonnull BigDecimal bigDecimal) {
        return VH.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String vmin(int n) {
        return VMIN.format(n);
    }

    @Nonnull
    @Nonempty
    public static String vmin(double d) {
        return VMIN.format(d);
    }

    @Nonnull
    @Nonempty
    public static String vmin(@Nonnull BigDecimal bigDecimal) {
        return VMIN.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String vmax(int n) {
        return VMAX.format(n);
    }

    @Nonnull
    @Nonempty
    public static String vmax(double d) {
        return VMAX.format(d);
    }

    @Nonnull
    @Nonempty
    public static String vmax(@Nonnull BigDecimal bigDecimal) {
        return VMAX.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String ch(int n) {
        return CH.format(n);
    }

    @Nonnull
    @Nonempty
    public static String ch(double d) {
        return CH.format(d);
    }

    @Nonnull
    @Nonempty
    public static String ch(@Nonnull BigDecimal bigDecimal) {
        return CH.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String in(int n) {
        return LENGTH_IN.format(n);
    }

    @Nonnull
    @Nonempty
    public static String in(double d) {
        return LENGTH_IN.format(d);
    }

    @Nonnull
    @Nonempty
    public static String in(@Nonnull BigDecimal bigDecimal) {
        return LENGTH_IN.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String cm(int n) {
        return LENGTH_CM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String cm(double d) {
        return LENGTH_CM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String cm(@Nonnull BigDecimal bigDecimal) {
        return LENGTH_CM.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String mm(int n) {
        return LENGTH_MM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String mm(double d) {
        return LENGTH_MM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String mm(@Nonnull BigDecimal bigDecimal) {
        return LENGTH_MM.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String q(int n) {
        return LENGTH_Q.format(n);
    }

    @Nonnull
    @Nonempty
    public static String q(double d) {
        return LENGTH_Q.format(d);
    }

    @Nonnull
    @Nonempty
    public static String q(@Nonnull BigDecimal bigDecimal) {
        return LENGTH_Q.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String pt(int n) {
        return LENGTH_PT.format(n);
    }

    @Nonnull
    @Nonempty
    public static String pt(double d) {
        return LENGTH_PT.format(d);
    }

    @Nonnull
    @Nonempty
    public static String pt(@Nonnull BigDecimal bigDecimal) {
        return LENGTH_PT.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String pc(int n) {
        return LENGTH_PC.format(n);
    }

    @Nonnull
    @Nonempty
    public static String pc(double d) {
        return LENGTH_PC.format(d);
    }

    @Nonnull
    @Nonempty
    public static String pc(@Nonnull BigDecimal bigDecimal) {
        return LENGTH_PC.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String perc(int n) {
        return PERCENTAGE.format(n);
    }

    @Nonnull
    @Nonempty
    public static String perc(double d) {
        return PERCENTAGE.format(d);
    }

    @Nonnull
    @Nonempty
    public static String perc(@Nonnull BigDecimal bigDecimal) {
        return PERCENTAGE.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String deg(int n) {
        return ANGLE_DEG.format(n);
    }

    @Nonnull
    @Nonempty
    public static String deg(double d) {
        return ANGLE_DEG.format(d);
    }

    @Nonnull
    @Nonempty
    public static String deg(@Nonnull BigDecimal bigDecimal) {
        return ANGLE_DEG.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String rad(int n) {
        return ANGLE_RAD.format(n);
    }

    @Nonnull
    @Nonempty
    public static String rad(double d) {
        return ANGLE_RAD.format(d);
    }

    @Nonnull
    @Nonempty
    public static String rad(@Nonnull BigDecimal bigDecimal) {
        return ANGLE_RAD.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String grad(int n) {
        return ANGLE_GRAD.format(n);
    }

    @Nonnull
    @Nonempty
    public static String grad(double d) {
        return ANGLE_GRAD.format(d);
    }

    @Nonnull
    @Nonempty
    public static String grad(@Nonnull BigDecimal bigDecimal) {
        return ANGLE_GRAD.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String turn(int n) {
        return ANGLE_TURN.format(n);
    }

    @Nonnull
    @Nonempty
    public static String turn(double d) {
        return ANGLE_TURN.format(d);
    }

    @Nonnull
    @Nonempty
    public static String turn(@Nonnull BigDecimal bigDecimal) {
        return ANGLE_TURN.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String ms(int n) {
        return TIME_MS.format(n);
    }

    @Nonnull
    @Nonempty
    public static String ms(double d) {
        return TIME_MS.format(d);
    }

    @Nonnull
    @Nonempty
    public static String ms(@Nonnull BigDecimal bigDecimal) {
        return TIME_MS.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String s(int n) {
        return TIME_S.format(n);
    }

    @Nonnull
    @Nonempty
    public static String s(double d) {
        return TIME_S.format(d);
    }

    @Nonnull
    @Nonempty
    public static String s(@Nonnull BigDecimal bigDecimal) {
        return TIME_S.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String hz(int n) {
        return FREQ_HZ.format(n);
    }

    @Nonnull
    @Nonempty
    public static String hz(double d) {
        return FREQ_HZ.format(d);
    }

    @Nonnull
    @Nonempty
    public static String hz(@Nonnull BigDecimal bigDecimal) {
        return FREQ_HZ.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String khz(int n) {
        return FREQ_KHZ.format(n);
    }

    @Nonnull
    @Nonempty
    public static String khz(double d) {
        return FREQ_KHZ.format(d);
    }

    @Nonnull
    @Nonempty
    public static String khz(@Nonnull BigDecimal bigDecimal) {
        return FREQ_KHZ.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String dpi(int n) {
        return DPI.format(n);
    }

    @Nonnull
    @Nonempty
    public static String dpi(double d) {
        return DPI.format(d);
    }

    @Nonnull
    @Nonempty
    public static String dpi(@Nonnull BigDecimal bigDecimal) {
        return DPI.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String dpcm(int n) {
        return DPCM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String dpcm(double d) {
        return DPCM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String dpcm(@Nonnull BigDecimal bigDecimal) {
        return DPCM.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String dppx(int n) {
        return DPPX.format(n);
    }

    @Nonnull
    @Nonempty
    public static String dppx(double d) {
        return DPPX.format(d);
    }

    @Nonnull
    @Nonempty
    public static String dppx(@Nonnull BigDecimal bigDecimal) {
        return DPPX.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String fr(int n) {
        return FR.format(n);
    }

    @Nonnull
    @Nonempty
    public static String fr(double d) {
        return FR.format(d);
    }

    @Nonnull
    @Nonempty
    public static String fr(@Nonnull BigDecimal bigDecimal) {
        return FR.format(bigDecimal);
    }

    @Nonnull
    @Nonempty
    public static String zero() {
        return "0";
    }

    static {
        LENGTH_PX = PX;
    }
}

