/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSExpression;
import saoui.shade.com.helger.css.decl.ICSSExpressionMathMember;
import saoui.shade.com.helger.css.decl.ICSSExpressionMember;

@NotThreadSafe
public class CSSExpressionMemberFunction
implements ICSSExpressionMember,
ICSSSourceLocationAware,
ICSSExpressionMathMember {
    private final String m_sFunctionName;
    private final CSSExpression m_aExpression;
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    private static String _skipBracketsAtEnd(@Nonnull String string) {
        String string2 = string.trim();
        if (string2.length() > 2 && string2.endsWith("()")) {
            return string2.substring(0, string2.length() - 2).trim();
        }
        return string2;
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String string, @Nullable CSSExpression cSSExpression) {
        ValueEnforcer.notEmpty(string, "FunctionName");
        this.m_sFunctionName = CSSExpressionMemberFunction._skipBracketsAtEnd(string);
        this.m_aExpression = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public final String getFunctionName() {
        return this.m_sFunctionName;
    }

    public boolean isExpressionFunction() {
        return this.m_sFunctionName.startsWith("expression(") || this.m_sFunctionName.equals("expression");
    }

    @Nullable
    public final CSSExpression getExpression() {
        return this.m_aExpression;
    }

    public final boolean hasExpression() {
        return this.m_aExpression != null;
    }

    @Override
    @Nonnull
    public CSSExpressionMemberFunction getClone() {
        return new CSSExpressionMemberFunction(this.m_sFunctionName, this.m_aExpression);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (this.m_aExpression == null) {
            if (this.m_sFunctionName.endsWith(")")) {
                return this.m_sFunctionName;
            }
            return this.m_sFunctionName + "()";
        }
        return this.m_sFunctionName + "(" + this.m_aExpression.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberFunction cSSExpressionMemberFunction = (CSSExpressionMemberFunction)object;
        return this.m_sFunctionName.equals(cSSExpressionMemberFunction.m_sFunctionName) && EqualsHelper.equals(this.m_aExpression, cSSExpressionMemberFunction.m_aExpression);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sFunctionName).append(this.m_aExpression).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("funcName", this.m_sFunctionName).appendIfNotNull("expression", this.m_aExpression).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

