/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.ICSSExpressionMember;

@NotThreadSafe
public class CSSExpressionMemberLineNames
implements ICSSExpressionMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aMembers = new CommonsArrayList<String>();
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberLineNames() {
    }

    public CSSExpressionMemberLineNames(@Nonnull Iterable<? extends String> iterable) {
        this.m_aMembers.addAll(iterable);
    }

    @Nonnull
    public CSSExpressionMemberLineNames addMember(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Member");
        this.m_aMembers.add(string);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberLineNames addMember(@Nonnegative int n, @Nonnull @Nonempty String string) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(string, "Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add(string);
        } else {
            this.m_aMembers.add(n, string);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull String string) {
        return this.m_aMembers.removeObject(string);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Override
    @Nonnull
    public CSSExpressionMemberLineNames getClone() {
        return new CSSExpressionMemberLineNames(this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl = true;
        for (String string : this.m_aMembers) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberLineNames cSSExpressionMemberLineNames = (CSSExpressionMemberLineNames)object;
        return this.m_aMembers.equals(cSSExpressionMemberLineNames.m_aMembers);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMembers)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

