/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMathProduct;
import saoui.shade.com.helger.css.decl.ICSSExpressionMathMember;

@NotThreadSafe
public class CSSExpressionMemberMathUnitProduct
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final CSSExpressionMemberMathProduct m_aProduct;

    public CSSExpressionMemberMathUnitProduct(@Nonnull @Nonempty CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct) {
        this.m_aProduct = ValueEnforcer.notNull(cSSExpressionMemberMathProduct, "Product");
    }

    @Nonnull
    public final CSSExpressionMemberMathProduct getProduct() {
        return this.m_aProduct;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return "(" + this.m_aProduct.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aProduct.getSourceLocation();
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aProduct.setSourceLocation(cSSSourceLocation);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = (CSSExpressionMemberMathUnitProduct)object;
        return this.m_aProduct.equals(cSSExpressionMemberMathUnitProduct.m_aProduct);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aProduct).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("product", this.m_aProduct).getToString();
    }
}

