/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.collection.impl.CommonsHashSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsSet;
import saoui.shade.com.helger.css.ECSSUnit;

@Immutable
public final class CSSExpressionTermOptimizer {
    private static final ICommonsSet<String> UNIT_VALUES_0 = new CommonsHashSet<String>();
    private static final CSSExpressionTermOptimizer INSTANCE;

    private CSSExpressionTermOptimizer() {
    }

    @Nonnull
    @Nonempty
    public static String getOptimizedValue(@Nonnull @Nonempty String string) {
        if (UNIT_VALUES_0.contains(string)) {
            return "0";
        }
        if (string.length() == 7 && string.charAt(0) == '#' && string.charAt(1) == string.charAt(2) && string.charAt(3) == string.charAt(4) && string.charAt(5) == string.charAt(6)) {
            return Character.toString('#') + string.charAt(1) + string.charAt(3) + string.charAt(5);
        }
        return string;
    }

    static {
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            UNIT_VALUES_0.add(eCSSUnit.format(0));
        }
        INSTANCE = new CSSExpressionTermOptimizer();
    }
}

