/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.lang.ICloneable;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriteable;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSHSLA;
import saoui.shade.com.helger.css.decl.ICSSColor;
import saoui.shade.com.helger.css.utils.CSSColorHelper;

@NotThreadSafe
public class CSSHSL
implements ICSSWriteable,
ICSSVersionAware,
ICSSColor,
ICloneable<CSSHSL> {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;

    public CSSHSL(@Nonnull CSSHSL cSSHSL) {
        this(cSSHSL.getHue(), cSSHSL.getSaturation(), cSSHSL.getLightness());
    }

    public CSSHSL(int n, int n2, int n3) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(n)), Integer.toString(CSSColorHelper.getHSLPercentageValue(n2)) + "%", Integer.toString(CSSColorHelper.getHSLPercentageValue(n3)) + "%");
    }

    public CSSHSL(float f, float f2, float f3) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(f)), Float.toString(CSSColorHelper.getHSLPercentageValue(f2)) + "%", Float.toString(CSSColorHelper.getHSLPercentageValue(f3)) + "%");
    }

    public CSSHSL(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        this.setHue(string);
        this.setSaturation(string2);
        this.setLightness(string3);
    }

    @Nonnull
    @Nonempty
    public final String getHue() {
        return this.m_sHue;
    }

    @Nonnull
    public final CSSHSL setHue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Hue");
        this.m_sHue = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getSaturation() {
        return this.m_sSaturation;
    }

    @Nonnull
    public final CSSHSL setSaturation(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Saturation");
        this.m_sSaturation = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getLightness() {
        return this.m_sLightness;
    }

    @Nonnull
    public final CSSHSL setLightness(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Lightness");
        this.m_sLightness = string;
        return this;
    }

    @Nonnull
    public CSSHSLA getAsHSLA(float f) {
        return new CSSHSLA(this, f);
    }

    @Nonnull
    public CSSHSLA getAsHSLA(@Nonnull @Nonempty String string) {
        return new CSSHSLA(this, string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "hsl(" + this.m_sHue + ',' + this.m_sSaturation + ',' + this.m_sLightness + ")";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return this.getAsString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nonnull
    public CSSHSL getClone() {
        return new CSSHSL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSHSL cSSHSL = (CSSHSL)object;
        return this.m_sHue.equals(cSSHSL.m_sHue) && this.m_sSaturation.equals(cSSHSL.m_sSaturation) && this.m_sLightness.equals(cSSHSL.m_sLightness);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sHue).append(this.m_sSaturation).append(this.m_sLightness).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Hue", this.m_sHue).append("Saturation", this.m_sSaturation).append("Lightness", this.m_sLightness).getToString();
    }
}

