/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.lang.ICloneable;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriteable;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSHSL;
import saoui.shade.com.helger.css.decl.ICSSColor;
import saoui.shade.com.helger.css.utils.CSSColorHelper;

@NotThreadSafe
public class CSSHSLA
implements ICSSWriteable,
ICSSVersionAware,
ICSSColor,
ICloneable<CSSHSLA> {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;
    private String m_sOpacity;

    public CSSHSLA(@Nonnull CSSHSLA cSSHSLA) {
        this(cSSHSLA.getHue(), cSSHSLA.getSaturation(), cSSHSLA.getLightness(), cSSHSLA.getOpacity());
    }

    public CSSHSLA(@Nonnull CSSHSL cSSHSL, float f) {
        this(cSSHSL, Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSHSLA(@Nonnull CSSHSL cSSHSL, @Nonnull @Nonempty String string) {
        this(cSSHSL.getHue(), cSSHSL.getSaturation(), cSSHSL.getLightness(), string);
    }

    public CSSHSLA(int n, int n2, int n3, float f) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(n)), Integer.toString(CSSColorHelper.getHSLPercentageValue(n2)) + "%", Integer.toString(CSSColorHelper.getHSLPercentageValue(n3)) + "%", Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSHSLA(float f, float f2, float f3, float f4) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(f)), Float.toString(CSSColorHelper.getHSLPercentageValue(f2)) + "%", Float.toString(CSSColorHelper.getHSLPercentageValue(f3)) + "%", Float.toString(CSSColorHelper.getOpacityToUse(f4)));
    }

    public CSSHSLA(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4) {
        this.setHue(string);
        this.setSaturation(string2);
        this.setLightness(string3);
        this.setOpacity(string4);
    }

    @Nonnull
    @Nonempty
    public final String getHue() {
        return this.m_sHue;
    }

    @Nonnull
    public final CSSHSLA setHue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Hue");
        this.m_sHue = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getSaturation() {
        return this.m_sSaturation;
    }

    @Nonnull
    public final CSSHSLA setSaturation(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Saturation");
        this.m_sSaturation = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getLightness() {
        return this.m_sLightness;
    }

    @Nonnull
    public final CSSHSLA setLightness(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Lightness");
        this.m_sLightness = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getOpacity() {
        return this.m_sOpacity;
    }

    @Nonnull
    public final CSSHSLA setOpacity(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Opacity");
        this.m_sOpacity = string;
        return this;
    }

    @Nonnull
    public CSSHSL getAsHSL() {
        return new CSSHSL(this.m_sHue, this.m_sSaturation, this.m_sLightness);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "hsla(" + this.m_sHue + ',' + this.m_sSaturation + ',' + this.m_sLightness + ',' + this.m_sOpacity + ")";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return this.getAsString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nonnull
    public CSSHSLA getClone() {
        return new CSSHSLA(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSHSLA cSSHSLA = (CSSHSLA)object;
        return this.m_sHue.equals(cSSHSLA.m_sHue) && this.m_sSaturation.equals(cSSHSLA.m_sSaturation) && this.m_sLightness.equals(cSSHSLA.m_sLightness) && this.m_sOpacity.equals(cSSHSLA.m_sOpacity);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sHue).append(this.m_sSaturation).append(this.m_sLightness).append(this.m_sOpacity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Hue", this.m_sHue).append("Saturation", this.m_sSaturation).append("Lightness", this.m_sLightness).append("Opacity", this.m_sOpacity).getToString();
    }
}

