/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSWriteable;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSMediaQuery;
import saoui.shade.com.helger.css.decl.CSSURI;

@NotThreadSafe
public class CSSImportRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private CSSURI m_aLocation;
    private final ICommonsList<CSSMediaQuery> m_aMediaQueries = new CommonsArrayList<CSSMediaQuery>();
    private CSSSourceLocation m_aSourceLocation;

    public CSSImportRule(@Nonnull String string) {
        this(new CSSURI(string));
    }

    public CSSImportRule(@Nonnull CSSURI cSSURI) {
        this.setLocation(cSSURI);
    }

    public boolean hasMediaQueries() {
        return this.m_aMediaQueries.isNotEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnull CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.notNull(cSSMediaQuery, "MediaQuery");
        this.m_aMediaQueries.add(cSSMediaQuery);
        return this;
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnegative int n, @Nonnull CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(cSSMediaQuery, "MediaQuery");
        if (n >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add(cSSMediaQuery);
        } else {
            this.m_aMediaQueries.add(n, cSSMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery cSSMediaQuery) {
        return this.m_aMediaQueries.removeObject(cSSMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(int n) {
        return this.m_aMediaQueries.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        return this.m_aMediaQueries.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaQuery> getAllMediaQueries() {
        return (ICommonsList)this.m_aMediaQueries.getClone();
    }

    @Nonnull
    public final CSSURI getLocation() {
        return this.m_aLocation;
    }

    @Nonnull
    @Nonempty
    public final String getLocationString() {
        return this.m_aLocation.getURI();
    }

    @Nonnull
    public final CSSImportRule setLocation(@Nonnull CSSURI cSSURI) {
        ValueEnforcer.notNull(cSSURI, "Location");
        this.m_aLocation = cSSURI;
        return this;
    }

    @Nonnull
    public final CSSImportRule setLocationString(@Nonnull String string) {
        this.m_aLocation.setURI(string);
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@import ").append(this.m_aLocation.getAsCSSString(iCSSWriterSettings, n));
        if (!this.m_aMediaQueries.isEmpty()) {
            stringBuilder.append(' ');
            boolean bl2 = true;
            for (CSSMediaQuery cSSMediaQuery : this.m_aMediaQueries) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(bl ? "," : ", ");
                }
                stringBuilder.append(cSSMediaQuery.getAsCSSString(iCSSWriterSettings, n));
            }
        }
        return stringBuilder.append(';').append(iCSSWriterSettings.getNewLineString()).toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSImportRule cSSImportRule = (CSSImportRule)object;
        return this.m_aLocation.equals(cSSImportRule.m_aLocation) && this.m_aMediaQueries.equals(cSSImportRule.m_aMediaQueries);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aLocation).append(this.m_aMediaQueries)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("location", this.m_aLocation).append("mediaQueries", this.m_aMediaQueries).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

