/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSDeclaration;
import saoui.shade.com.helger.css.decl.CSSDeclarationContainer;
import saoui.shade.com.helger.css.decl.IHasCSSDeclarations;

@NotThreadSafe
public class CSSKeyframesBlock
implements IHasCSSDeclarations<CSSKeyframesBlock>,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aKeyframesSelectors;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public CSSKeyframesBlock(String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue(stringArray, "KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList<String>(stringArray);
    }

    public CSSKeyframesBlock(@Nonnull @Nonempty Iterable<String> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, "KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList<Iterable<String>>(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllKeyframesSelectors() {
        return (ICommonsList)this.m_aKeyframesSelectors.getClone();
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.m_aKeyframesSelectors) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSKeyframesBlock cSSKeyframesBlock = (CSSKeyframesBlock)object;
        return this.m_aKeyframesSelectors.equals(cSSKeyframesBlock.m_aKeyframesSelectors) && this.m_aDeclarations.equals(cSSKeyframesBlock.m_aDeclarations);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aKeyframesSelectors)).append((Iterable)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("KeyframesSelectors", this.m_aKeyframesSelectors).append("Declarations", this.m_aDeclarations).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

