/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSKeyframesBlock;
import saoui.shade.com.helger.css.decl.ICSSTopLevelRule;

@NotThreadSafe
public class CSSKeyframesRule
implements ICSSTopLevelRule,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private final String m_sAnimationName;
    private final ICommonsList<CSSKeyframesBlock> m_aBlocks = new CommonsArrayList<CSSKeyframesBlock>();
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, '@') && StringHelper.endsWithIgnoreCase(string, "keyframes");
    }

    public CSSKeyframesRule(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.isTrue(CSSKeyframesRule.isValidDeclaration(string), "Declaration is invalid");
        this.m_sDeclaration = string;
        this.m_sAnimationName = string2;
    }

    @Nonnull
    @Nonempty
    public final String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    @Nonempty
    public final String getAnimationName() {
        return this.m_sAnimationName;
    }

    public boolean hasBlocks() {
        return this.m_aBlocks.isNotEmpty();
    }

    @Nonnegative
    public int getBlockCount() {
        return this.m_aBlocks.size();
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
        ValueEnforcer.notNull(cSSKeyframesBlock, "KeyframesBlock");
        this.m_aBlocks.add(cSSKeyframesBlock);
        return this;
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnegative int n, @Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(cSSKeyframesBlock, "KeyframesBlock");
        if (n >= this.getBlockCount()) {
            this.m_aBlocks.add(cSSKeyframesBlock);
        } else {
            this.m_aBlocks.add(n, cSSKeyframesBlock);
        }
        return this;
    }

    @Nonnull
    public EChange removeBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
        return this.m_aBlocks.removeObject(cSSKeyframesBlock);
    }

    @Nonnull
    public EChange removeBlock(@Nonnegative int n) {
        return this.m_aBlocks.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllBlocks() {
        return this.m_aBlocks.removeAll();
    }

    @Nullable
    public CSSKeyframesBlock getBlockAtIndex(@Nonnegative int n) {
        return (CSSKeyframesBlock)this.m_aBlocks.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSKeyframesBlock> getAllBlocks() {
        return (ICommonsList)this.m_aBlocks.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (!iCSSWriterSettings.isWriteKeyframesRules()) {
            return "";
        }
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && this.m_aBlocks.isEmpty()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(this.m_sDeclaration);
        stringBuilder.append(' ').append(this.m_sAnimationName).append(bl ? "{" : " {");
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        for (CSSKeyframesBlock cSSKeyframesBlock : this.m_aBlocks) {
            String string = cSSKeyframesBlock.getAsCSSString(iCSSWriterSettings, n + 1);
            if (!StringHelper.hasText(string)) continue;
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
            }
            stringBuilder.append(string);
            if (bl) continue;
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getIndent(n));
        }
        stringBuilder.append('}');
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSKeyframesRule cSSKeyframesRule = (CSSKeyframesRule)object;
        return this.m_sDeclaration.equals(cSSKeyframesRule.m_sDeclaration) && this.m_sAnimationName.equals(cSSKeyframesRule.m_sAnimationName) && this.m_aBlocks.equals(cSSKeyframesRule.m_aBlocks);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sDeclaration).append(this.m_sAnimationName).append(this.m_aBlocks)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("declaration", this.m_sDeclaration).append("animationName", this.m_sAnimationName).append("blocks", this.m_aBlocks).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

