/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriteable;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSExpression;
import saoui.shade.com.helger.css.media.ECSSMediaExpressionFeature;

@NotThreadSafe
public class CSSMediaExpression
implements ICSSWriteable,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sFeature;
    private final CSSExpression m_aValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eCSSMediaExpressionFeature) {
        this(eCSSMediaExpressionFeature.getName());
    }

    public CSSMediaExpression(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eCSSMediaExpressionFeature, @Nullable CSSExpression cSSExpression) {
        this(eCSSMediaExpressionFeature.getName(), cSSExpression);
    }

    public CSSMediaExpression(@Nonnull @Nonempty String string, @Nullable CSSExpression cSSExpression) {
        ValueEnforcer.notEmpty(string, "Feature");
        this.m_sFeature = string;
        this.m_aValue = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public final String getFeature() {
        return this.m_sFeature;
    }

    @Nullable
    public final CSSExpression getValue() {
        return this.m_aValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.m_sFeature);
        if (this.m_aValue != null) {
            stringBuilder.append(':').append(this.m_aValue.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaExpression cSSMediaExpression = (CSSMediaExpression)object;
        return this.m_sFeature.equals(cSSMediaExpression.m_sFeature) && EqualsHelper.equals(this.m_aValue, cSSMediaExpression.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sFeature).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("feature", this.m_sFeature).appendIfNotNull("value", this.m_aValue).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

