/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSWriteable;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.utils.CSSURLHelper;

@NotThreadSafe
public class CSSNamespaceRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sPrefix;
    private String m_sURL;
    private CSSSourceLocation m_aSourceLocation;

    public CSSNamespaceRule(@Nonnull String string) {
        this(null, string);
    }

    public CSSNamespaceRule(@Nullable String string, @Nonnull String string2) {
        this.setNamespacePrefix(string);
        this.setNamespaceURL(string2);
    }

    @Nullable
    public final String getNamespacePrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public final CSSNamespaceRule setNamespacePrefix(@Nullable String string) {
        this.m_sPrefix = string;
        return this;
    }

    @Nonnull
    public final String getNamespaceURL() {
        return this.m_sURL;
    }

    @Nonnull
    public final CSSNamespaceRule setNamespaceURL(@Nonnull String string) {
        ValueEnforcer.notNull(string, "URL");
        this.m_sURL = string;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteNamespaceRules()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@namespace ");
        if (StringHelper.hasText(this.m_sPrefix)) {
            stringBuilder.append(this.m_sPrefix).append(' ');
        }
        if (StringHelper.hasText(this.m_sURL)) {
            stringBuilder.append(CSSURLHelper.getAsCSSURL(this.m_sURL, false));
        } else {
            stringBuilder.append("\"\"");
        }
        return stringBuilder.append(';').append(iCSSWriterSettings.getNewLineString()).toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSNamespaceRule cSSNamespaceRule = (CSSNamespaceRule)object;
        return EqualsHelper.equals(this.m_sPrefix, cSSNamespaceRule.m_sPrefix) && this.m_sURL.equals(cSSNamespaceRule.m_sURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).append(this.m_sURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("prefix", this.m_sPrefix).append("URL", this.m_sURL).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

