/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSWriteable;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.ICSSSelectorMember;

@NotThreadSafe
public class CSSSelector
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSSelectorMember> m_aMembers = new CommonsArrayList<ICSSSelectorMember>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return this.m_aMembers.isNotEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSelector addMember(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull(iCSSSelectorMember, "Member");
        this.m_aMembers.add(iCSSSelectorMember);
        return this;
    }

    @Nonnull
    public CSSSelector addMember(@Nonnegative int n, @Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(iCSSSelectorMember, "Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add(iCSSSelectorMember);
        } else {
            this.m_aMembers.add(n, iCSSSelectorMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        return this.m_aMembers.removeObject(iCSSSelectorMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nullable
    public ICSSSelectorMember getMemberAtIndex(@Nonnegative int n) {
        return (ICSSSelectorMember)this.m_aMembers.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSSelectorMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return StringHelper.getImplodedMapped(this.m_aMembers, iCSSSelectorMember -> iCSSSelectorMember.getAsCSSString(iCSSWriterSettings, n));
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelector cSSSelector = (CSSSelector)object;
        return this.m_aMembers.equals(cSSSelector.m_aMembers);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMembers)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

