/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSExpression;
import saoui.shade.com.helger.css.decl.ICSSSelectorMember;

@NotThreadSafe
public class CSSSelectorMemberFunctionLike
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sFuncName;
    private final CSSExpression m_aParamExpr;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberFunctionLike(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression) {
        ValueEnforcer.notEmpty(string, "FunctionName");
        if (!string.endsWith("(")) {
            throw new IllegalArgumentException("function name must end with a '('");
        }
        ValueEnforcer.notNull(cSSExpression, "ParameterExpression");
        this.m_sFuncName = string;
        this.m_aParamExpr = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFuncName;
    }

    @Nonnull
    public CSSExpression getParameterExpression() {
        return this.m_aParamExpr;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sFuncName + this.m_aParamExpr.getAsCSSString(iCSSWriterSettings, n) + ')';
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = (CSSSelectorMemberFunctionLike)object;
        return this.m_sFuncName.equals(cSSSelectorMemberFunctionLike.m_sFuncName) && this.m_aParamExpr.equals(cSSSelectorMemberFunctionLike.m_aParamExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sFuncName).append(this.m_aParamExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("functionName", this.m_sFuncName).append("paramExpr", this.m_aParamExpr).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

