/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.CSSSelector;
import saoui.shade.com.helger.css.decl.ICSSSelectorMember;

@NotThreadSafe
public class CSSSelectorMemberHost
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final CSSSelector m_aSelector;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberHost(@Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull(cSSSelector, "SimpleSelector");
        this.m_aSelector = cSSSelector;
    }

    @Nonnull
    public final CSSSelector getSelector() {
        return this.m_aSelector;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder(":host(");
        stringBuilder.append(this.m_aSelector.getAsCSSString(iCSSWriterSettings, 0));
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberHost cSSSelectorMemberHost = (CSSSelectorMemberHost)object;
        return this.m_aSelector.equals(cSSSelectorMemberHost.m_aSelector);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aSelector).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Selector", this.m_aSelector).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

