/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.ICSSSupportsConditionMember;

@NotThreadSafe
public class CSSSupportsConditionNegation
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final ICSSSupportsConditionMember m_aSupportsMember;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSupportsConditionNegation(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        this.m_aSupportsMember = ValueEnforcer.notNull(iCSSSupportsConditionMember, "SupportsMember");
    }

    @Nonnull
    public ICSSSupportsConditionMember getSupportsMember() {
        return this.m_aSupportsMember;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return "not " + this.m_aSupportsMember.getAsCSSString(iCSSWriterSettings, n);
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsConditionNegation cSSSupportsConditionNegation = (CSSSupportsConditionNegation)object;
        return this.m_aSupportsMember.equals(cSSSupportsConditionNegation.m_aSupportsMember);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aSupportsMember).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("supportsMember", this.m_aSupportsMember).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

