/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.ICSSVersionAware;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.decl.AbstractHasTopLevelRules;
import saoui.shade.com.helger.css.decl.ICSSSupportsConditionMember;
import saoui.shade.com.helger.css.decl.ICSSTopLevelRule;

@NotThreadSafe
public class CSSSupportsRule
extends AbstractHasTopLevelRules
implements ICSSTopLevelRule,
ICSSSourceLocationAware,
ICSSVersionAware {
    private final ICommonsList<ICSSSupportsConditionMember> m_aConditionMembers = new CommonsArrayList<ICSSSupportsConditionMember>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSupportConditionMembers() {
        return this.m_aConditionMembers.isNotEmpty();
    }

    @Nonnegative
    public int getSupportsConditionMemberCount() {
        return this.m_aConditionMembers.size();
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.notNull(iCSSSupportsConditionMember, "SupportsConditionMember");
        this.m_aConditionMembers.add(iCSSSupportsConditionMember);
        return this;
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnegative int n, @Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(iCSSSupportsConditionMember, "SupportsConditionMember");
        if (n >= this.getSupportsConditionMemberCount()) {
            this.m_aConditionMembers.add(iCSSSupportsConditionMember);
        } else {
            this.m_aConditionMembers.add(n, iCSSSupportsConditionMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        return this.m_aConditionMembers.removeObject(iCSSSupportsConditionMember);
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnegative int n) {
        return this.m_aConditionMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllSupportsConditionMembers() {
        return this.m_aConditionMembers.removeAll();
    }

    @Nullable
    public ICSSSupportsConditionMember getSupportsConditionMemberAtIndex(@Nonnegative int n) {
        return (ICSSSupportsConditionMember)this.m_aConditionMembers.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSSupportsConditionMember> getAllSupportConditionMembers() {
        return (ICommonsList)this.m_aConditionMembers.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (!iCSSWriterSettings.isWriteSupportsRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aRules.size();
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("@supports ");
        boolean bl2 = true;
        for (ICSSSupportsConditionMember iCSSWriteable : this.m_aConditionMembers) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(iCSSWriteable.getAsCSSString(iCSSWriterSettings, n));
        }
        if (n2 == 0) {
            stringBuilder.append(bl ? "{}" : " {}" + iCSSWriterSettings.getNewLineString());
        } else {
            stringBuilder.append(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString());
            bl2 = true;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                String string = iCSSTopLevelRule.getAsCSSString(iCSSWriterSettings, n + 1);
                if (!StringHelper.hasText(string)) continue;
                if (bl2) {
                    bl2 = false;
                } else if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getNewLineString());
                }
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
                }
                stringBuilder.append(string);
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getNewLineString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsRule cSSSupportsRule = (CSSSupportsRule)object;
        return this.m_aConditionMembers.equals(cSSSupportsRule.m_aConditionMembers) && this.m_aRules.equals(cSSSupportsRule.m_aRules);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aConditionMembers)).append((Iterable)this.m_aRules)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("conditionMembers", this.m_aConditionMembers).append("rules", this.m_aRules).appendIfNotNull("SourceLocation", this.m_aSourceLocation).getToString();
    }
}

