/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.decl.visit;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.collection.NonBlockingStack;
import saoui.shade.com.helger.css.ICSSSourceLocationAware;
import saoui.shade.com.helger.css.decl.CSSDeclaration;
import saoui.shade.com.helger.css.decl.CSSExpression;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberFunction;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMath;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMathProduct;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberTermURI;
import saoui.shade.com.helger.css.decl.CSSFontFaceRule;
import saoui.shade.com.helger.css.decl.CSSImportRule;
import saoui.shade.com.helger.css.decl.CSSKeyframesBlock;
import saoui.shade.com.helger.css.decl.CSSKeyframesRule;
import saoui.shade.com.helger.css.decl.CSSMediaRule;
import saoui.shade.com.helger.css.decl.CSSNamespaceRule;
import saoui.shade.com.helger.css.decl.CSSPageMarginBlock;
import saoui.shade.com.helger.css.decl.CSSPageRule;
import saoui.shade.com.helger.css.decl.CSSSelector;
import saoui.shade.com.helger.css.decl.CSSStyleRule;
import saoui.shade.com.helger.css.decl.CSSSupportsRule;
import saoui.shade.com.helger.css.decl.CSSUnknownRule;
import saoui.shade.com.helger.css.decl.CSSViewportRule;
import saoui.shade.com.helger.css.decl.ICSSExpressionMathMember;
import saoui.shade.com.helger.css.decl.ICSSExpressionMember;
import saoui.shade.com.helger.css.decl.ICSSTopLevelRule;
import saoui.shade.com.helger.css.decl.visit.ICSSUrlVisitor;
import saoui.shade.com.helger.css.decl.visit.ICSSVisitor;

@NotThreadSafe
public class CSSVisitorForUrl
implements ICSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private final NonBlockingStack<ICSSTopLevelRule> m_aTopLevelRule = new NonBlockingStack();

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        this.m_aVisitor = ValueEnforcer.notNull(iCSSUrlVisitor, "Visitor");
    }

    @Nonnull
    public ICSSUrlVisitor getVisitor() {
        return this.m_aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule cSSImportRule) {
        this.m_aVisitor.onImport(cSSImportRule);
    }

    @Override
    public void onNamespace(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
    }

    private void _recursiveCheckMathMember(@Nullable ICSSTopLevelRule iCSSTopLevelRule, @Nonnull CSSDeclaration cSSDeclaration, @Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        if (iCSSExpressionMathMember instanceof CSSExpressionMemberFunction) {
            CSSExpressionMemberFunction cSSExpressionMemberFunction = (CSSExpressionMemberFunction)iCSSExpressionMathMember;
            this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberFunction.getExpression());
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMath) {
            CSSExpressionMemberMath cSSExpressionMemberMath = (CSSExpressionMemberMath)iCSSExpressionMathMember;
            for (ICSSExpressionMathMember iCSSExpressionMathMember2 : cSSExpressionMemberMath.getAllMembers()) {
                this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember2);
            }
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMathProduct) {
            CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = (CSSExpressionMemberMathProduct)iCSSExpressionMathMember;
            for (ICSSExpressionMathMember iCSSExpressionMathMember3 : cSSExpressionMemberMathProduct.getAllMembers()) {
                this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember3);
            }
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMathUnitProduct) {
            CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = (CSSExpressionMemberMathUnitProduct)iCSSExpressionMathMember;
            this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberMathUnitProduct.getProduct());
        }
    }

    private void _recursiveCheckExpression(@Nullable ICSSTopLevelRule iCSSTopLevelRule, @Nonnull CSSDeclaration cSSDeclaration, @Nullable CSSExpression cSSExpression) {
        if (cSSExpression != null) {
            for (ICSSExpressionMember iCSSExpressionMember : cSSExpression.getAllMembers()) {
                ICSSSourceLocationAware iCSSSourceLocationAware;
                if (iCSSExpressionMember instanceof CSSExpressionMemberFunction) {
                    iCSSSourceLocationAware = (CSSExpressionMemberFunction)iCSSExpressionMember;
                    this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, ((CSSExpressionMemberFunction)iCSSSourceLocationAware).getExpression());
                    continue;
                }
                if (iCSSExpressionMember instanceof CSSExpressionMemberMath) {
                    iCSSSourceLocationAware = (CSSExpressionMemberMath)iCSSExpressionMember;
                    for (ICSSExpressionMathMember iCSSExpressionMathMember : ((CSSExpressionMemberMath)iCSSSourceLocationAware).getAllMembers()) {
                        this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember);
                    }
                    continue;
                }
                if (!(iCSSExpressionMember instanceof CSSExpressionMemberTermURI)) continue;
                iCSSSourceLocationAware = (CSSExpressionMemberTermURI)iCSSExpressionMember;
                this.m_aVisitor.onUrlDeclaration(iCSSTopLevelRule, cSSDeclaration, (CSSExpressionMemberTermURI)iCSSSourceLocationAware);
            }
        }
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        ICSSTopLevelRule iCSSTopLevelRule = this.m_aTopLevelRule.isEmpty() ? null : this.m_aTopLevelRule.peek();
        this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, cSSDeclaration.getExpression());
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.push(cSSStyleRule);
    }

    @Override
    public void onStyleRuleSelector(@Nonnull CSSSelector cSSSelector) {
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.push(cSSPageRule);
    }

    @Override
    public void onBeginPageMarginBlock(@Nonnull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageMarginBlock(@Nonnull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.push(cSSFontFaceRule);
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.push(cSSMediaRule);
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.push(cSSKeyframesRule);
    }

    @Override
    public void onBeginKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.push(cSSViewportRule);
    }

    @Override
    public void onEndViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.push(cSSSupportsRule);
    }

    @Override
    public void onEndSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onUnknownRule(@Nonnull CSSUnknownRule cSSUnknownRule) {
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

