/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.handler;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.decl.CSSDeclarationList;
import saoui.shade.com.helger.css.decl.CascadingStyleSheet;
import saoui.shade.com.helger.css.handler.CSSHandlingException;
import saoui.shade.com.helger.css.handler.CSSNodeToDomainObject;
import saoui.shade.com.helger.css.handler.ECSSNodeType;
import saoui.shade.com.helger.css.parser.CSSNode;
import saoui.shade.com.helger.css.reader.CSSReader;
import saoui.shade.com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;

@Immutable
public final class CSSHandler {
    public static final boolean DEFAULT_USE_SOURCE_LOCATION = true;
    private static final CSSHandler INSTANCE = new CSSHandler();

    private CSSHandler() {
    }

    @Nonnull
    @Deprecated
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        return CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, CSSReader.getDefaultInterpretErrorHandler(), true, cSSNode);
    }

    @Nonnull
    @Deprecated
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        return CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, iCSSInterpretErrorHandler, true, cSSNode);
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull(eCSSVersion, "Version");
        ValueEnforcer.notNull(cSSNode, "Node");
        if (!ECSSNodeType.ROOT.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a root node!");
        }
        ValueEnforcer.notNull(iCSSInterpretErrorHandler, "ErrorHandler");
        return new CSSNodeToDomainObject(eCSSVersion, iCSSInterpretErrorHandler, bl).createCascadingStyleSheetFromNode(cSSNode);
    }

    @Nonnull
    @Deprecated
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        return CSSHandler.readDeclarationListFromNode(eCSSVersion, CSSReader.getDefaultInterpretErrorHandler(), true, cSSNode);
    }

    @Deprecated
    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        return CSSHandler.readDeclarationListFromNode(eCSSVersion, iCSSInterpretErrorHandler, true, cSSNode);
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull(eCSSVersion, "Version");
        ValueEnforcer.notNull(cSSNode, "Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a style declaration node!");
        }
        ValueEnforcer.notNull(iCSSInterpretErrorHandler, "ErrorHandler");
        return new CSSNodeToDomainObject(eCSSVersion, iCSSInterpretErrorHandler, bl).createDeclarationListFromNode(cSSNode);
    }
}

