/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.handler;

import javax.annotation.Nonnull;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.parser.CSSNode;

public class CSSHandlingException
extends RuntimeException {
    private final CSSNode m_aNode;

    @Nonnull
    private static String _getSourceLocation(@Nonnull CSSNode cSSNode) {
        StringBuilder stringBuilder = new StringBuilder();
        CSSSourceLocation cSSSourceLocation = cSSNode.getSourceLocation();
        if (cSSSourceLocation != null) {
            String string = null;
            if (cSSSourceLocation.hasFirstTokenArea()) {
                string = cSSSourceLocation.getFirstTokenLocationAsString();
                stringBuilder.append(string);
            }
            if (cSSSourceLocation.hasLastTokenArea()) {
                String string2 = cSSSourceLocation.getLastTokenLocationAsString();
                if (string == null || !string.equals(string2)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append(string2);
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
        }
        return stringBuilder.toString();
    }

    public CSSHandlingException(@Nonnull CSSNode cSSNode, @Nonnull String string) {
        super(CSSHandlingException._getSourceLocation(cSSNode) + string);
        this.m_aNode = cSSNode;
    }

    @Nonnull
    public CSSNode getNode() {
        return this.m_aNode;
    }
}

