/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.handler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.css.CSSSourceLocation;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.decl.CSSDeclaration;
import saoui.shade.com.helger.css.decl.CSSDeclarationList;
import saoui.shade.com.helger.css.decl.CSSExpression;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberFunction;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberLineNames;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMath;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMathProduct;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberMathUnitSimple;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberTermSimple;
import saoui.shade.com.helger.css.decl.CSSExpressionMemberTermURI;
import saoui.shade.com.helger.css.decl.CSSFontFaceRule;
import saoui.shade.com.helger.css.decl.CSSImportRule;
import saoui.shade.com.helger.css.decl.CSSKeyframesBlock;
import saoui.shade.com.helger.css.decl.CSSKeyframesRule;
import saoui.shade.com.helger.css.decl.CSSMediaExpression;
import saoui.shade.com.helger.css.decl.CSSMediaQuery;
import saoui.shade.com.helger.css.decl.CSSMediaRule;
import saoui.shade.com.helger.css.decl.CSSNamespaceRule;
import saoui.shade.com.helger.css.decl.CSSPageMarginBlock;
import saoui.shade.com.helger.css.decl.CSSPageRule;
import saoui.shade.com.helger.css.decl.CSSSelector;
import saoui.shade.com.helger.css.decl.CSSSelectorAttribute;
import saoui.shade.com.helger.css.decl.CSSSelectorMemberFunctionLike;
import saoui.shade.com.helger.css.decl.CSSSelectorMemberHost;
import saoui.shade.com.helger.css.decl.CSSSelectorMemberHostContext;
import saoui.shade.com.helger.css.decl.CSSSelectorMemberNot;
import saoui.shade.com.helger.css.decl.CSSSelectorMemberSlotted;
import saoui.shade.com.helger.css.decl.CSSSelectorSimpleMember;
import saoui.shade.com.helger.css.decl.CSSStyleRule;
import saoui.shade.com.helger.css.decl.CSSSupportsConditionDeclaration;
import saoui.shade.com.helger.css.decl.CSSSupportsConditionNegation;
import saoui.shade.com.helger.css.decl.CSSSupportsConditionNested;
import saoui.shade.com.helger.css.decl.CSSSupportsRule;
import saoui.shade.com.helger.css.decl.CSSURI;
import saoui.shade.com.helger.css.decl.CSSUnknownRule;
import saoui.shade.com.helger.css.decl.CSSViewportRule;
import saoui.shade.com.helger.css.decl.CascadingStyleSheet;
import saoui.shade.com.helger.css.decl.ECSSAttributeOperator;
import saoui.shade.com.helger.css.decl.ECSSExpressionOperator;
import saoui.shade.com.helger.css.decl.ECSSMathOperator;
import saoui.shade.com.helger.css.decl.ECSSSelectorCombinator;
import saoui.shade.com.helger.css.decl.ECSSSupportsConditionOperator;
import saoui.shade.com.helger.css.decl.ICSSExpressionMathMember;
import saoui.shade.com.helger.css.decl.ICSSExpressionMember;
import saoui.shade.com.helger.css.decl.ICSSPageRuleMember;
import saoui.shade.com.helger.css.decl.ICSSSelectorMember;
import saoui.shade.com.helger.css.decl.ICSSSupportsConditionMember;
import saoui.shade.com.helger.css.handler.CSSHandlingException;
import saoui.shade.com.helger.css.handler.ECSSNodeType;
import saoui.shade.com.helger.css.media.ECSSMediaExpressionFeature;
import saoui.shade.com.helger.css.media.ECSSMedium;
import saoui.shade.com.helger.css.parser.CSSNode;
import saoui.shade.com.helger.css.parser.CSSParseHelper;
import saoui.shade.com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;

@NotThreadSafe
final class CSSNodeToDomainObject {
    private final ECSSVersion m_eVersion;
    private final ICSSInterpretErrorHandler m_aErrorHandler;
    private final boolean m_bUseSourceLocation;

    public CSSNodeToDomainObject(@Nonnull ECSSVersion eCSSVersion, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl) {
        this.m_eVersion = ValueEnforcer.notNull(eCSSVersion, "Version");
        this.m_aErrorHandler = ValueEnforcer.notNull(iCSSInterpretErrorHandler, "ErrorHandler");
        this.m_bUseSourceLocation = bl;
    }

    private void _expectNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSNodeType eCSSNodeType) {
        if (!eCSSNodeType.isNode(cSSNode, this.m_eVersion)) {
            throw new CSSHandlingException(cSSNode, "Expected a '" + eCSSNodeType.getNodeName(this.m_eVersion) + "' node but received a '" + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + "'");
        }
    }

    private void _throwUnexpectedChildrenCount(@Nonnull CSSNode cSSNode, @Nonnull @Nonempty String string) {
        this.m_aErrorHandler.onCSSInterpretationError(string);
        for (int i = 0; i < cSSNode.jjtGetNumChildren(); ++i) {
            this.m_aErrorHandler.onCSSInterpretationError("  " + cSSNode.jjtGetChild(i));
        }
        throw new CSSHandlingException(cSSNode, string);
    }

    @Nonnull
    private CSSImportRule _createImportRule(@Nonnull CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.IMPORTRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at last 2 children but got " + n + "!");
        }
        CSSURI cSSURI = null;
        int n2 = 0;
        if (n > 0) {
            object = cSSNode.jjtGetChild(0);
            if (ECSSNodeType.URL.isNode((CSSNode)object, this.m_eVersion)) {
                cSSURI = new CSSURI(((CSSNode)object).getText());
                if (this.m_bUseSourceLocation) {
                    cSSURI.setSourceLocation(((CSSNode)object).getSourceLocation());
                }
                ++n2;
            } else if (!ECSSNodeType.MEDIALIST.isNode((CSSNode)object, this.m_eVersion)) {
                throw new IllegalStateException("Expected an URI or MEDIALIST node but got " + ECSSNodeType.getNodeName((CSSNode)object, this.m_eVersion));
            }
        }
        if (cSSURI == null) {
            cSSURI = new CSSURI(CSSParseHelper.extractStringValue(cSSNode.getText()));
            if (this.m_bUseSourceLocation) {
                cSSURI.setSourceLocation(cSSNode.getSourceLocation());
            }
        }
        object = new CSSImportRule(cSSURI);
        if (this.m_bUseSourceLocation) {
            ((CSSImportRule)object).setSourceLocation(cSSNode.getSourceLocation());
        }
        if (n > n2) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    ((CSSImportRule)object).addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                ++n2;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an MEDIALIST node but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
            }
        }
        if (n2 < n) {
            this.m_aErrorHandler.onCSSInterpretationError("Import statement has children which are unhandled.");
        }
        return object;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode cSSNode) {
        CSSSelectorAttribute cSSSelectorAttribute;
        this._expectNodeType(cSSNode, ECSSNodeType.ATTRIB);
        int n = cSSNode.jjtGetNumChildren();
        String string = null;
        int n2 = 0;
        if (n > 0 && ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            n2 = 1;
        }
        String string2 = cSSNode.getText();
        if (n == n2) {
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2);
        } else {
            int n3 = n2 + 2;
            if (n != n3) {
                this._throwUnexpectedChildrenCount(cSSNode, "Illegal number of children present (" + n + ") - expected " + n3);
            }
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            this._expectNodeType(cSSNode2, ECSSNodeType.ATTRIBOPERATOR);
            CSSNode cSSNode3 = cSSNode.jjtGetChild(n2 + 1);
            this._expectNodeType(cSSNode3, ECSSNodeType.ATTRIBVALUE);
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2, ECSSAttributeOperator.getFromNameOrNull(cSSNode2.getText()), cSSNode3.getText());
        }
        if (this.m_bUseSourceLocation) {
            cSSSelectorAttribute.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSSelectorAttribute;
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.ELEMENTNAME.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.HASH.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.CLASS.isNode(cSSNode, this.m_eVersion)) {
            if (n != 0) {
                this._throwUnexpectedChildrenCount(cSSNode, "CSS simple selector member expected 0 children and got " + n);
            }
            CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
            if (this.m_bUseSourceLocation) {
                cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSSelectorSimpleMember;
        }
        if (ECSSNodeType.ATTRIB.isNode(cSSNode, this.m_eVersion)) {
            return this._createSelectorAttribute(cSSNode);
        }
        if (ECSSNodeType.SELECTORCOMBINATOR.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            ECSSSelectorCombinator eCSSSelectorCombinator = ECSSSelectorCombinator.getFromNameOrNull(string);
            if (eCSSSelectorCombinator == null) {
                this.m_aErrorHandler.onCSSInterpretationError("Failed to parse CSS selector combinator '" + string + "'");
            }
            return eCSSSelectorCombinator;
        }
        if (ECSSNodeType.NEGATION.isNode(cSSNode, this.m_eVersion)) {
            CommonsArrayList<CSSSelector> commonsArrayList = new CommonsArrayList<CSSSelector>();
            for (int i = 0; i < n; ++i) {
                CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
                CSSSelector cSSSelector = this._createSelector(cSSNode2);
                commonsArrayList.add(cSSSelector);
            }
            CSSSelectorMemberNot cSSSelectorMemberNot = new CSSSelectorMemberNot(commonsArrayList);
            if (this.m_bUseSourceLocation) {
                cSSSelectorMemberNot.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSSelectorMemberNot;
        }
        if (ECSSNodeType.PSEUDO.isNode(cSSNode, this.m_eVersion)) {
            if (n == 0) {
                String string = cSSNode.getText();
                if (string.endsWith("(")) {
                    string = string + ')';
                }
                CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(string);
                if (this.m_bUseSourceLocation) {
                    cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                }
                return cSSSelectorSimpleMember;
            }
            if (n == 1) {
                CSSNode cSSNode3 = cSSNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(cSSNode3, this.m_eVersion)) {
                    CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText() + cSSNode3.getText() + ")");
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorSimpleMember;
                }
                if (ECSSNodeType.HOST.isNode(cSSNode3, this.m_eVersion)) {
                    CSSSelector cSSSelector = new CSSSelector();
                    int n2 = cSSNode3.jjtGetNumChildren();
                    for (int i = 0; i < n2; ++i) {
                        cSSSelector.addMember(this._createSelectorMember(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberHost cSSSelectorMemberHost = new CSSSelectorMemberHost(cSSSelector);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberHost.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberHost;
                }
                if (ECSSNodeType.HOSTCONTEXT.isNode(cSSNode3, this.m_eVersion)) {
                    CSSSelector cSSSelector = new CSSSelector();
                    int n3 = cSSNode3.jjtGetNumChildren();
                    for (int i = 0; i < n3; ++i) {
                        cSSSelector.addMember(this._createSelectorMember(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberHostContext cSSSelectorMemberHostContext = new CSSSelectorMemberHostContext(cSSSelector);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberHostContext.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberHostContext;
                }
                if (ECSSNodeType.SLOTTED.isNode(cSSNode3, this.m_eVersion)) {
                    CSSSelector cSSSelector = new CSSSelector();
                    int n4 = cSSNode3.jjtGetNumChildren();
                    for (int i = 0; i < n4; ++i) {
                        cSSSelector.addMember(this._createSelectorMember(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberSlotted cSSSelectorMemberSlotted = new CSSSelectorMemberSlotted(cSSSelector);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberSlotted.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberSlotted;
                }
                CSSExpression cSSExpression = this._createExpression(cSSNode3);
                CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = new CSSSelectorMemberFunctionLike(cSSNode.getText(), cSSExpression);
                if (this.m_bUseSourceLocation) {
                    cSSSelectorMemberFunctionLike.setSourceLocation(cSSNode.getSourceLocation());
                }
                return cSSSelectorMemberFunctionLike;
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + n + " args: " + cSSNode.toString());
        }
        this.m_aErrorHandler.onCSSInterpretationError("Unsupported selector child: " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SELECTOR);
        CSSSelector cSSSelector = new CSSSelector();
        if (this.m_bUseSourceLocation) {
            cSSSelector.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            ICSSSelectorMember iCSSSelectorMember = this._createSelectorMember(cSSNode2);
            if (iCSSSelectorMember == null) continue;
            cSSSelector.addMember(iCSSSelectorMember);
        }
        return cSSSelector;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionCalcProduct(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.CALCPRODUCT);
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = new CSSExpressionMemberMathProduct();
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberMathProduct.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            ICSSExpressionMathMember iCSSExpressionMathMember;
            if (ECSSNodeType.CALCUNIT.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                if (n == 0) {
                    iCSSExpressionMathMember = new CSSExpressionMemberMathUnitSimple(cSSNode2.getText());
                    if (this.m_bUseSourceLocation) {
                        ((CSSExpressionMemberMathUnitSimple)iCSSExpressionMathMember).setSourceLocation(cSSNode2.getSourceLocation());
                    }
                    cSSExpressionMemberMathProduct.addMember(iCSSExpressionMathMember);
                    continue;
                }
                if (n == 1 && ECSSNodeType.FUNCTION.isNode(cSSNode2.jjtGetChild(0), this.m_eVersion)) {
                    cSSExpressionMemberMathProduct.addMember(this._createExpressionFunction(cSSNode2.jjtGetChild(0)));
                    continue;
                }
                if (n == 1 && ECSSNodeType.CALC.isNode(cSSNode2.jjtGetChild(0), this.m_eVersion)) {
                    cSSExpressionMemberMathProduct.addMember(this._createExpressionCalc(cSSNode2.jjtGetChild(0)));
                    continue;
                }
                if (n % 2 == 0) {
                    this._throwUnexpectedChildrenCount(cSSNode2, "CSS math unit expected odd child count and got " + n);
                }
                iCSSExpressionMathMember = new CSSExpressionMemberMathProduct();
                for (int i = 0; i < n; ++i) {
                    CSSNode cSSNode3 = cSSNode2.jjtGetChild(i);
                    if (ECSSNodeType.CALCPRODUCT.isNode(cSSNode3, this.m_eVersion)) {
                        ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).addMember(this._createExpressionCalcProduct(cSSNode3));
                        continue;
                    }
                    if (ECSSNodeType.CALCSUMOPERATOR.isNode(cSSNode3, this.m_eVersion)) {
                        String string = cSSNode3.getText();
                        ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                        if (eCSSMathOperator == null) {
                            this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + string + "'");
                            continue;
                        }
                        ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).addMember(eCSSMathOperator);
                        continue;
                    }
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
                }
                if (this.m_bUseSourceLocation) {
                    ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).setSourceLocation(cSSNode2.getSourceLocation());
                }
                cSSExpressionMemberMathProduct.addMember(new CSSExpressionMemberMathUnitProduct((CSSExpressionMemberMathProduct)iCSSExpressionMathMember));
                continue;
            }
            if (ECSSNodeType.CALCPRODUCTOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                iCSSExpressionMathMember = ECSSMathOperator.getFromNameOrNull(string);
                if (iCSSExpressionMathMember == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math product operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMathProduct.addMember(iCSSExpressionMathMember);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMathProduct;
    }

    @Nonnull
    private CSSExpressionMemberTermURI _createExpressionURL(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.URL);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 0) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 children but got " + n + "!");
        }
        CSSURI cSSURI = new CSSURI(cSSNode.getText());
        CSSExpressionMemberTermURI cSSExpressionMemberTermURI = new CSSExpressionMemberTermURI(cSSURI);
        if (this.m_bUseSourceLocation) {
            CSSSourceLocation cSSSourceLocation = cSSNode.getSourceLocation();
            cSSURI.setSourceLocation(cSSSourceLocation);
            cSSExpressionMemberTermURI.setSourceLocation(cSSSourceLocation);
        }
        return cSSExpressionMemberTermURI;
    }

    @Nonnull
    private CSSExpressionMemberFunction _createExpressionFunction(@Nonnull CSSNode cSSNode) {
        CSSExpressionMemberFunction cSSExpressionMemberFunction;
        this._expectNodeType(cSSNode, ECSSNodeType.FUNCTION);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        String string = cSSNode.getText();
        if (n == 1) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
            CSSExpression cSSExpression = this._createExpression(cSSNode2);
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string, cSSExpression);
        } else {
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string);
        }
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberFunction.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSExpressionMemberFunction;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionCalc(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.CALC);
        CSSExpressionMemberMath cSSExpressionMemberMath = new CSSExpressionMemberMath();
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberMath.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.CALCPRODUCT.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpressionMemberMath.addMember(this._createExpressionCalcProduct(cSSNode2));
                continue;
            }
            if (ECSSNodeType.CALCSUMOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                if (eCSSMathOperator == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMath.addMember(eCSSMathOperator);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMath;
    }

    @Nonnull
    private CSSExpressionMemberLineNames _createExpressionLineNamesTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.LINE_NAMES);
        CSSExpressionMemberLineNames cSSExpressionMemberLineNames = new CSSExpressionMemberLineNames();
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberLineNames.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.LINE_NAME.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpressionMemberLineNames.addMember(cSSNode2.getText());
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberLineNames;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPRTERM);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        if (n == 0) {
            CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = new CSSExpressionMemberTermSimple(cSSNode.getText());
            if (this.m_bUseSourceLocation) {
                cSSExpressionMemberTermSimple.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSExpressionMemberTermSimple;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        if (ECSSNodeType.URL.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionURL(cSSNode2);
        }
        if (ECSSNodeType.FUNCTION.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionFunction(cSSNode2);
        }
        if (ECSSNodeType.CALC.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionCalc(cSSNode2);
        }
        if (ECSSNodeType.LINE_NAMES.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionLineNamesTerm(cSSNode2);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPR);
        CSSExpression cSSExpression = new CSSExpression();
        if (this.m_bUseSourceLocation) {
            cSSExpression.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.EXPRTERM.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpression.addMember(this._createExpressionTerm(cSSNode2));
                continue;
            }
            if (ECSSNodeType.EXPROPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSExpressionOperator eCSSExpressionOperator = ECSSExpressionOperator.getFromNameOrNull(string);
                if (eCSSExpressionOperator == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse expression operator '" + string + "'");
                    continue;
                }
                cSSExpression.addMember(eCSSExpressionOperator);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpression;
    }

    @Nullable
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATION);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 3) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 1-3 children but got " + n + "!");
        }
        if (n == 1) {
            return null;
        }
        if (!ECSSNodeType.EXPR.isNode(cSSNode.jjtGetChild(1), this.m_eVersion)) {
            return null;
        }
        String string = cSSNode.jjtGetChild(0).getText();
        if (string == null) {
            return null;
        }
        CSSExpression cSSExpression = this._createExpression(cSSNode.jjtGetChild(1));
        boolean bl = false;
        if (n == 3) {
            object = cSSNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode((CSSNode)object, this.m_eVersion)) {
                bl = true;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an " + ECSSNodeType.IMPORTANT.getNodeName(this.m_eVersion) + " token but got a " + ECSSNodeType.getNodeName((CSSNode)object, this.m_eVersion));
            }
        }
        object = new CSSDeclaration(string, cSSExpression, bl);
        if (this.m_bUseSourceLocation) {
            ((CSSDeclaration)object).setSourceLocation(cSSNode.getSourceLocation());
        }
        return object;
    }

    private void _readStyleDeclarationList(@Nonnull CSSNode cSSNode, @Nonnull Consumer<CSSDeclaration> consumer) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATIONLIST);
        int n = cSSNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            CSSDeclaration cSSDeclaration;
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (!ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2, this.m_eVersion) || (cSSDeclaration = this._createDeclaration(cSSNode2)) == null) continue;
            consumer.accept(cSSDeclaration);
        }
    }

    @Nullable
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLERULE);
        CSSStyleRule cSSStyleRule = new CSSStyleRule();
        if (this.m_bUseSourceLocation) {
            cSSStyleRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        boolean bl = true;
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.SELECTOR.isNode(cSSNode2, this.m_eVersion)) {
                if (!bl) {
                    this.m_aErrorHandler.onCSSInterpretationError("Found a selector after a declaration!");
                }
                cSSStyleRule.addSelector(this._createSelector(cSSNode2));
                continue;
            }
            bl = false;
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode2, cSSStyleRule::addDeclaration);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        if (cSSStyleRule.getSelectorCount() == 0) {
            return null;
        }
        return cSSStyleRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSPageRule _createPageRule(@Nonnull CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.PAGERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (this.m_eVersion == ECSSVersion.CSS30) {
            CSSNode cSSNode2;
            if (n < 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child but got " + n + "!");
            }
            CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
            for (int i = 0; i < n - 1; ++i) {
                cSSNode2 = cSSNode.jjtGetChild(i);
                this._expectNodeType(cSSNode2, ECSSNodeType.PAGESELECTOR);
                commonsArrayList.add(cSSNode2.getText());
            }
            CSSPageRule cSSPageRule = new CSSPageRule(commonsArrayList);
            if (this.m_bUseSourceLocation) {
                cSSPageRule.setSourceLocation(cSSNode.getSourceLocation());
            }
            cSSNode2 = cSSNode.jjtGetChild(n - 1);
            this._expectNodeType(cSSNode2, ECSSNodeType.PAGERULEBLOCK);
            int n2 = cSSNode2.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                ICSSPageRuleMember iCSSPageRuleMember;
                CSSNode cSSNode3 = cSSNode2.jjtGetChild(i);
                if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode3, this.m_eVersion)) {
                    iCSSPageRuleMember = this._createDeclaration(cSSNode3);
                    if (iCSSPageRuleMember == null) continue;
                    cSSPageRule.addMember(iCSSPageRuleMember);
                    continue;
                }
                if (ECSSNodeType.PAGEMARGINSYMBOL.isNode(cSSNode3, this.m_eVersion)) {
                    iCSSPageRuleMember = new CSSPageMarginBlock(cSSNode3.getText());
                    if (this.m_bUseSourceLocation) {
                        ((CSSPageMarginBlock)iCSSPageRuleMember).setSourceLocation(cSSNode3.getSourceLocation());
                    }
                    CSSNode cSSNode4 = cSSNode2.jjtGetChild(i + 1);
                    this._readStyleDeclarationList(cSSNode4, ((CSSPageMarginBlock)iCSSPageRuleMember)::addDeclaration);
                    cSSPageRule.addMember(iCSSPageRuleMember);
                    ++i;
                    continue;
                }
                if (ECSSNodeType.isErrorNode(cSSNode3, this.m_eVersion)) continue;
                this.m_aErrorHandler.onCSSInterpretationError("Unsupported page rule body child: " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
            }
            return cSSPageRule;
        }
        String string = null;
        int n3 = 0;
        if (n > 0 && ECSSNodeType.PSEUDOPAGE.isNode((CSSNode)(object = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            string = ((CSSNode)object).getText();
            ++n3;
        }
        object = new CSSPageRule(string);
        if (this.m_bUseSourceLocation) {
            ((CSSPageRule)object).setSourceLocation(cSSNode.getSourceLocation());
        }
        for (int i = n3; i < n; ++i) {
            CSSNode cSSNode5 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode5, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode5, ((CSSPageRule)object)::addMember);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode5, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported page rule child: " + ECSSNodeType.getNodeName(cSSNode5, this.m_eVersion));
        }
        return object;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        if (this.m_bUseSourceLocation) {
            cSSMediaRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    cSSMediaRule.addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode2);
                if (cSSStyleRule == null) continue;
                cSSMediaRule.addRule(cSSStyleRule);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createUnknownRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media-rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSMediaRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode cSSNode) {
        Object object;
        Object object2;
        if (ECSSNodeType.MEDIUM.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            if (ECSSMedium.getFromNameOrNull(string) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS " + this.m_eVersion.getVersionString() + " Media query uses unknown medium '" + string + "'");
            }
            CSSMediaQuery cSSMediaQuery = new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, string);
            if (this.m_bUseSourceLocation) {
                cSSMediaQuery.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSMediaQuery;
        }
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAQUERY);
        int n = cSSNode.jjtGetNumChildren();
        int n2 = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (n > 0 && ECSSNodeType.MEDIAMODIFIER.isNode((CSSNode)(object2 = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            object = ((CSSNode)object2).getText();
            if (object != null) {
                if ("not".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported media modifier '" + (String)object + "' found!");
                }
            }
            ++n2;
        }
        object2 = null;
        if (n > n2 && ECSSNodeType.MEDIUM.isNode((CSSNode)(object = cSSNode.jjtGetChild(n2)), this.m_eVersion)) {
            object2 = ((CSSNode)object).getText();
            if (ECSSMedium.getFromNameOrNull((String)object2) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS " + this.m_eVersion.getVersionString() + " media query uses unknown medium '" + (String)object2 + "'");
            }
            ++n2;
        }
        object = new CSSMediaQuery(eModifier, (String)object2);
        if (this.m_bUseSourceLocation) {
            ((CSSMediaQuery)object).setSourceLocation(cSSNode.getSourceLocation());
        }
        for (int i = n2; i < n; ++i) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(cSSNode2, this.m_eVersion)) {
                ((CSSMediaQuery)object).addMediaExpression(this._createMediaExpr(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media query child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return object;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode cSSNode) {
        CSSMediaExpression cSSMediaExpression;
        CSSNode cSSNode2;
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAEXPR);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 1 && n != 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 1 or 2 children but got " + n + "!");
        }
        if (!ECSSNodeType.MEDIAFEATURE.isNode(cSSNode2 = cSSNode.jjtGetChild(0), this.m_eVersion)) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        String string = cSSNode2.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(string) == null) {
            this.m_aErrorHandler.onCSSInterpretationWarning("Media expression uses unknown feature '" + string + "'");
        }
        if (n == 1) {
            cSSMediaExpression = new CSSMediaExpression(string);
        } else {
            CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
            cSSMediaExpression = new CSSMediaExpression(string, this._createExpression(cSSNode3));
        }
        if (this.m_bUseSourceLocation) {
            cSSMediaExpression.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSMediaExpression;
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.FONTFACERULE);
        String string = cSSNode.getText();
        CSSFontFaceRule cSSFontFaceRule = new CSSFontFaceRule(string);
        if (this.m_bUseSourceLocation) {
            cSSFontFaceRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode2, cSSFontFaceRule::addDeclaration);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSFontFaceRule;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.KEYFRAMESRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n == 0) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child but got " + n + "!");
        }
        String string = cSSNode.getText();
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String string2 = cSSNode2.getText();
        CSSKeyframesRule cSSKeyframesRule = new CSSKeyframesRule(string, string2);
        if (this.m_bUseSourceLocation) {
            cSSKeyframesRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        CSSKeyframesBlock cSSKeyframesBlock = null;
        for (int i = 1; i < n; ++i) {
            CommonsArrayList<String> commonsArrayList;
            CSSNode cSSNode3 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(cSSNode3, this.m_eVersion)) {
                commonsArrayList = new CommonsArrayList<String>();
                for (CSSNode cSSNode4 : cSSNode3) {
                    this._expectNodeType(cSSNode4, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    commonsArrayList.add(cSSNode4.getText());
                }
                cSSKeyframesBlock = new CSSKeyframesBlock(commonsArrayList);
                if (this.m_bUseSourceLocation) {
                    cSSKeyframesBlock.setSourceLocation(cSSNode3.getSourceLocation());
                }
                cSSKeyframesRule.addBlock(cSSKeyframesBlock);
                continue;
            }
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode3, this.m_eVersion)) {
                if (cSSKeyframesBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                commonsArrayList = cSSKeyframesBlock;
                this._readStyleDeclarationList(cSSNode3, arg_0 -> commonsArrayList.addDeclaration(arg_0));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode3, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
        }
        return cSSKeyframesRule;
    }

    @Nonnull
    private CSSViewportRule _createViewportRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.VIEWPORTRULE);
        String string = cSSNode.getText();
        CSSViewportRule cSSViewportRule = new CSSViewportRule(string);
        if (this.m_bUseSourceLocation) {
            cSSViewportRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode2, cSSViewportRule::addDeclaration);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported viewport rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSViewportRule;
    }

    @Nonnull
    private CSSNamespaceRule _createNamespaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.NAMESPACERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child and at last 2 children but got " + n + "!");
        }
        String string = null;
        int n2 = 0;
        if (ECSSNodeType.NAMESPACERULEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            ++n2;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
        this._expectNodeType(cSSNode2, ECSSNodeType.NAMESPACERULEURL);
        String string2 = CSSParseHelper.extractStringValue(cSSNode2.getText());
        CSSNamespaceRule cSSNamespaceRule = new CSSNamespaceRule(string, string2);
        if (this.m_bUseSourceLocation) {
            cSSNamespaceRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSNamespaceRule;
    }

    @Nullable
    private ICSSSupportsConditionMember _createSupportsConditionMemberRecursive(@Nonnull CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.SUPPORTSCONDITIONOPERATOR.isNode(cSSNode, this.m_eVersion)) {
            if (n != 0) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected no children but got " + n + "!");
            }
            return ECSSSupportsConditionOperator.getFromNameCaseInsensitiveOrNull(cSSNode.getText());
        }
        if (ECSSNodeType.SUPPORTSNEGATION.isNode(cSSNode, this.m_eVersion)) {
            ICSSSupportsConditionMember iCSSSupportsConditionMember;
            if (n != 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if ((iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode.jjtGetChild(0))) == null) {
                return null;
            }
            CSSSupportsConditionNegation cSSSupportsConditionNegation = new CSSSupportsConditionNegation(iCSSSupportsConditionMember);
            if (this.m_bUseSourceLocation) {
                cSSSupportsConditionNegation.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSSupportsConditionNegation;
        }
        if (ECSSNodeType.SUPPORTSCONDITIONINPARENS.isNode(cSSNode, this.m_eVersion)) {
            CSSNode cSSNode2;
            if (n != 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2 = cSSNode.jjtGetChild(0), this.m_eVersion)) {
                CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode2);
                if (cSSDeclaration == null) {
                    throw new CSSHandlingException(cSSNode2, "The style declaration in the @supports rule is invalid!");
                }
                CSSSupportsConditionDeclaration cSSSupportsConditionDeclaration = new CSSSupportsConditionDeclaration(cSSDeclaration);
                if (this.m_bUseSourceLocation) {
                    cSSSupportsConditionDeclaration.setSourceLocation(cSSNode2.getSourceLocation());
                }
                return cSSSupportsConditionDeclaration;
            }
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2, this.m_eVersion)) {
                CSSSupportsConditionNested cSSSupportsConditionNested = new CSSSupportsConditionNested();
                for (CSSNode cSSNode3 : cSSNode2) {
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsConditionNested.addMember(iCSSSupportsConditionMember);
                }
                if (this.m_bUseSourceLocation) {
                    cSSSupportsConditionNested.setSourceLocation(cSSNode2.getSourceLocation());
                }
                return cSSSupportsConditionNested;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supportsConditionInParents child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
            return null;
        }
        if (!ECSSNodeType.isErrorNode(cSSNode, this.m_eVersion)) {
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-condition child: " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion));
        }
        return null;
    }

    @Nonnull
    private CSSSupportsRule _createSupportsRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SUPPORTSRULE);
        CSSSupportsRule cSSSupportsRule = new CSSSupportsRule();
        if (this.m_bUseSourceLocation) {
            cSSSupportsRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsRule.addSupportConditionMember(iCSSSupportsConditionMember);
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode2);
                if (cSSStyleRule == null) continue;
                cSSSupportsRule.addRule(cSSStyleRule);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSSupportsRule;
    }

    @Nonnull
    private CSSUnknownRule _createUnknownRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.UNKNOWNRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 2 children but got " + n + "!");
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.UNKNOWNRULEPARAMETERLIST);
        CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
        this._expectNodeType(cSSNode3, ECSSNodeType.UNKNOWNRULEBODY);
        String string = cSSNode.getText();
        CSSUnknownRule cSSUnknownRule = new CSSUnknownRule(string);
        if (this.m_bUseSourceLocation) {
            cSSUnknownRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        cSSUnknownRule.setParameterList(cSSNode2.getText());
        cSSUnknownRule.setBody(cSSNode3.getText());
        return cSSUnknownRule;
    }

    private void _recursiveFillCascadingStyleSheetFromNode(@Nonnull CSSNode cSSNode, @Nonnull CascadingStyleSheet cascadingStyleSheet) {
        this._expectNodeType(cSSNode, ECSSNodeType.ROOT);
        if (this.m_bUseSourceLocation) {
            cascadingStyleSheet.setSourceLocation(cSSNode.getSourceLocation());
        }
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.CHARSET.isNode(cSSNode2, this.m_eVersion)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addImportRule(this._createImportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.NAMESPACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addNamespaceRule(this._createNamespaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode2);
                if (cSSStyleRule == null) continue;
                cascadingStyleSheet.addRule(cSSStyleRule);
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createUnknownRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.ROOT.isNode(cSSNode2, this.m_eVersion)) {
                this._recursiveFillCascadingStyleSheetFromNode(cSSNode2, cascadingStyleSheet);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode cSSNode) {
        CascadingStyleSheet cascadingStyleSheet = new CascadingStyleSheet();
        this._recursiveFillCascadingStyleSheetFromNode(cSSNode, cascadingStyleSheet);
        return cascadingStyleSheet;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode cSSNode) {
        CSSDeclarationList cSSDeclarationList = new CSSDeclarationList();
        if (this.m_bUseSourceLocation) {
            cSSDeclarationList.setSourceLocation(cSSNode.getSourceLocation());
        }
        this._readStyleDeclarationList(cSSNode, cSSDeclarationList::addDeclaration);
        return cSSDeclarationList;
    }
}

