/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.parser;

import java.util.TreeSet;
import saoui.shade.com.helger.css.parser.Token;

public class ParseException
extends Exception {
    private static final String INDENT = "    ";
    protected static final String EOL = "\n";
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        this(token, nArray, stringArray, null);
    }

    public ParseException(Token token, int[][] nArray, String[] stringArray, String string) {
        super(ParseException._initialise(token, nArray, stringArray, string));
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
    }

    public ParseException(String string) {
        super(string);
    }

    private static String _initialise(Token token, int[][] nArray, String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < nArray.length; ++i) {
            if (n < nArray[i].length) {
                n = nArray[i].length;
            }
            for (int j = 0; j < nArray[i].length; ++j) {
                treeSet.add(stringArray[nArray[i][j]]);
            }
        }
        for (String string2 : treeSet) {
            stringBuilder.append(INDENT).append(string2).append(EOL);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("Encountered unexpected token:");
        Token token2 = token.next;
        for (int i = 0; i < n; ++i) {
            String string3 = token2.image;
            String string4 = ParseException.add_escapes(string3);
            if (i != 0) {
                stringBuilder2.append(' ');
            }
            if (token2.kind == 0) {
                stringBuilder2.append(stringArray[0]);
                break;
            }
            stringBuilder2.append(" \"");
            stringBuilder2.append(string4);
            stringBuilder2.append("\"");
            stringBuilder2.append(" " + stringArray[token2.kind]);
            token2 = token2.next;
        }
        stringBuilder2.append(EOL).append(INDENT).append("at line ").append(token.next.beginLine).append(", column ").append(token.next.beginColumn);
        stringBuilder2.append(".").append(EOL);
        if (nArray.length != 0) {
            stringBuilder2.append(EOL).append("Was expecting").append(nArray.length == 1 ? ":" : " one of:").append(EOL).append(EOL).append((CharSequence)stringBuilder);
        }
        return stringBuilder2.toString();
    }

    static String add_escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block10;
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
            }
        }
        return stringBuilder.toString();
    }
}

