/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.property;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.regex.RegExHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.ECSSVendorPrefix;
import saoui.shade.com.helger.css.property.AbstractCSSProperty;
import saoui.shade.com.helger.css.property.ECSSProperty;
import saoui.shade.com.helger.css.property.customizer.ICSSPropertyCustomizer;
import saoui.shade.com.helger.css.utils.CSSColorHelper;

@NotThreadSafe
public class CSSPropertyColors
extends AbstractCSSProperty {
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public CSSPropertyColors(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, n, n2);
    }

    public CSSPropertyColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, iCSSPropertyCustomizer, n, n2);
    }

    public CSSPropertyColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        ValueEnforcer.isGT0(n, "MinNumbers");
        ValueEnforcer.isGT0(n2, "MaxNumbers");
        ValueEnforcer.isTrue(n <= n2, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    @Override
    @Nonnegative
    public final int getMinimumArgumentCount() {
        return this.m_nMinArgCount;
    }

    @Override
    @Nonnegative
    public final int getMaximumArgumentCount() {
        return this.m_nMaxArgCount;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray(string.trim(), "\\s+");
        if (stringArray.length < this.getMinimumArgumentCount() || stringArray.length > this.getMaximumArgumentCount()) {
            return false;
        }
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (super.isValidValue(string3) || CSSColorHelper.isColorValue(string3)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyColors getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyColors(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount());
    }

    @Override
    @Nonnull
    public CSSPropertyColors getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyColors(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyColors cSSPropertyColors = (CSSPropertyColors)object;
        return this.m_nMinArgCount == cSSPropertyColors.m_nMinArgCount && this.m_nMaxArgCount == cSSPropertyColors.m_nMaxArgCount;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_nMinArgCount).append(this.m_nMaxArgCount).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("MinArgCount", this.m_nMinArgCount).append("MaxArgCount", this.m_nMaxArgCount).getToString();
    }
}

