/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.property;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableObject;
import saoui.shade.com.helger.commons.collection.impl.CommonsHashSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsSet;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.ECSSVendorPrefix;
import saoui.shade.com.helger.css.property.AbstractCSSProperty;
import saoui.shade.com.helger.css.property.ECSSProperty;
import saoui.shade.com.helger.css.property.customizer.ICSSPropertyCustomizer;

@NotThreadSafe
public class CSSPropertyEnum
extends AbstractCSSProperty {
    private final ICommonsSet<String> m_aEnumValues;

    @Deprecated
    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, (String[])null);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, String ... stringArray) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, stringArray);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, String ... stringArray) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, stringArray);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        ValueEnforcer.notEmptyNoNullValue(stringArray, "EnumValues");
        this.m_aEnumValues = new CommonsHashSet<String>(stringArray.length);
        for (String string : stringArray) {
            if (StringHelper.hasNoText(string)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(string);
        }
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, iterable);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, iterable);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        ValueEnforcer.notEmptyNoNullValue(iterable, "EnumValues");
        this.m_aEnumValues = new CommonsHashSet<String>();
        for (String string : iterable) {
            if (StringHelper.hasNoText(string)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(string);
        }
    }

    private CSSPropertyEnum(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnull @Nonempty Set<String> set) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        this.m_aEnumValues = new CommonsHashSet<Set<String>>(set);
    }

    @Nonnull
    @ReturnsMutableObject(value="Design")
    protected final ICommonsSet<String> directGetEnumValues() {
        return this.m_aEnumValues;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        return super.isValidValue(string) || this.m_aEnumValues.contains(string);
    }

    @Override
    @Nonnull
    public CSSPropertyEnum getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnum(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), (Set<String>)this.m_aEnumValues);
    }

    @Override
    @Nonnull
    public CSSPropertyEnum getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyEnum(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), (Set<String>)this.m_aEnumValues);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyEnum cSSPropertyEnum = (CSSPropertyEnum)object;
        return this.m_aEnumValues.equals(cSSPropertyEnum.m_aEnumValues);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aEnumValues)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("enumValues", this.m_aEnumValues).getToString();
    }
}

